/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ScheduleIntervalSpec {
    private final Duration every;
    private final Duration offset;

    public ScheduleIntervalSpec(@Nonnull Duration every) {
        this(every, null);
    }

    public ScheduleIntervalSpec(@Nonnull Duration every, @Nullable Duration offset) {
        this.every = (Duration)Preconditions.checkNotNull((Object)every);
        this.offset = offset;
    }

    @Nonnull
    public Duration getEvery() {
        return this.every;
    }

    @Nullable
    public Duration getOffset() {
        return this.offset;
    }

    public String toString() {
        return "ScheduleIntervalSpec{every=" + this.every + ", offset=" + this.offset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleIntervalSpec that = (ScheduleIntervalSpec)o;
        return Objects.equals(this.every, that.every) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.every, this.offset);
    }
}

