/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import com.google.common.base.Preconditions;
import io.temporal.worker.tuning.SlotInfo;
import io.temporal.worker.tuning.SlotMarkUsedContext;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseContext;
import io.temporal.worker.tuning.SlotReserveContext;
import io.temporal.worker.tuning.SlotSupplier;
import java.util.Optional;
import java.util.concurrent.Semaphore;

public class FixedSizeSlotSupplier<SI extends SlotInfo>
implements SlotSupplier<SI> {
    private final int numSlots;
    private final Semaphore executorSlotsSemaphore;

    public FixedSizeSlotSupplier(int numSlots) {
        Preconditions.checkArgument((numSlots > 0 ? 1 : 0) != 0, (Object)"FixedSizeSlotSupplier must have at least one slot");
        this.numSlots = numSlots;
        this.executorSlotsSemaphore = new Semaphore(numSlots);
    }

    @Override
    public SlotPermit reserveSlot(SlotReserveContext<SI> ctx) throws InterruptedException {
        this.executorSlotsSemaphore.acquire();
        return new SlotPermit();
    }

    @Override
    public Optional<SlotPermit> tryReserveSlot(SlotReserveContext<SI> ctx) {
        boolean gotOne = this.executorSlotsSemaphore.tryAcquire();
        if (gotOne) {
            return Optional.of(new SlotPermit());
        }
        return Optional.empty();
    }

    @Override
    public void markSlotUsed(SlotMarkUsedContext<SI> ctx) {
    }

    @Override
    public void releaseSlot(SlotReleaseContext<SI> ctx) {
        this.executorSlotsSemaphore.release();
    }

    @Override
    public int getMaximumSlots() {
        return this.numSlots;
    }

    public String toString() {
        return "FixedSizeSlotSupplier{numSlots=" + this.numSlots + '}';
    }
}

