/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import com.google.common.collect.ImmutableList;
import io.temporal.activity.ActivityMethod;
import io.temporal.common.MethodRetry;
import io.temporal.common.metadata.POJOActivityInterfaceMetadata;
import io.temporal.common.metadata.POJOActivityMethodMetadata;
import io.temporal.common.metadata.POJOReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class POJOActivityImplMetadata {
    private final List<POJOActivityInterfaceMetadata> activityInterfaces;
    private final List<POJOActivityMethodMetadata> activityMethods;

    public static POJOActivityImplMetadata newInstance(Class<?> implementationClass) {
        return new POJOActivityImplMetadata(implementationClass);
    }

    private POJOActivityImplMetadata(Class<?> implClass) {
        if (implClass.isInterface() || implClass.isPrimitive() || implClass.isAnnotation() || implClass.isArray() || implClass.isEnum()) {
            throw new IllegalArgumentException("concrete class expected: " + implClass);
        }
        for (Method method : implClass.getMethods()) {
            if (method.getAnnotation(ActivityMethod.class) != null) {
                throw new IllegalArgumentException("Found @ActivityMethod annotation on \"" + method + "\" This annotation can be used only on the interface method it implements.");
            }
            if (method.getAnnotation(MethodRetry.class) == null) continue;
            throw new IllegalArgumentException("Found @MethodRetry annotation on \"" + method + "\" This annotation can be used only on the interface method it implements.");
        }
        ArrayList<POJOActivityInterfaceMetadata> activityInterfaces = new ArrayList<POJOActivityInterfaceMetadata>();
        HashMap<String, POJOActivityMethodMetadata> byName = new HashMap<String, POJOActivityMethodMetadata>();
        Set<Class<?>> interfaces = POJOReflectionUtils.getTopLevelInterfaces(implClass);
        for (Class<?> anInterface : interfaces) {
            POJOActivityInterfaceMetadata interfaceMetadata = POJOActivityInterfaceMetadata.newImplementationInterface(anInterface);
            activityInterfaces.add(interfaceMetadata);
            List<POJOActivityMethodMetadata> methods = interfaceMetadata.getMethodsMetadata();
            for (POJOActivityMethodMetadata methodMetadata : methods) {
                POJOActivityMethodMetadata registeredMM = byName.put(methodMetadata.getActivityTypeName(), methodMetadata);
                if (registeredMM == null || registeredMM.equals(methodMetadata)) continue;
                throw new IllegalArgumentException("Duplicated name: \"" + methodMetadata.getActivityTypeName() + "\" declared at \"" + registeredMM.getMethod() + "\" registered through \"" + registeredMM.getInterfaceType() + "\" and \"" + methodMetadata.getMethod() + "\" registered through \"" + methodMetadata.getInterfaceType() + "\"");
            }
        }
        if (byName.isEmpty()) {
            throw new IllegalArgumentException("Class doesn't implement any non empty interface annotated with @ActivityInterface: " + implClass.getName());
        }
        this.activityInterfaces = ImmutableList.copyOf(activityInterfaces);
        this.activityMethods = ImmutableList.copyOf(byName.values());
    }

    public List<POJOActivityInterfaceMetadata> getActivityInterfaces() {
        return this.activityInterfaces;
    }

    public List<POJOActivityMethodMetadata> getActivityMethods() {
        return this.activityMethods;
    }
}

