/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.client.UpdateOptions;
import io.temporal.client.WorkflowInvocationHandler;
import io.temporal.client.WorkflowStub;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.client.WorkflowUpdateStage;
import io.temporal.common.Experimental;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@Experimental
public final class UpdateWithStartWorkflowOperation<R> {
    private final AtomicBoolean invoked = new AtomicBoolean(false);
    private WorkflowStub stub;
    private UpdateOptions<R> options;
    private Object[] updateArgs;
    private Object[] workflowArgs;
    private final CompletableFuture<WorkflowUpdateHandle<R>> handle;
    @Nullable
    private final Functions.Proc updateRequest;

    public static <R> Builder<R> newBuilder(Functions.Func<R> request) {
        return new Builder(() -> request.apply());
    }

    public static <A1, R> Builder<R> newBuilder(Functions.Func1<A1, R> request, A1 arg1) {
        return new Builder(() -> request.apply(arg1));
    }

    public static <A1, A2, R> Builder<R> newBuilder(Functions.Func2<A1, A2, R> request, A1 arg1, A2 arg2) {
        return new Builder(() -> request.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> Builder<R> newBuilder(Functions.Func3<A1, A2, A3, R> request, A1 arg1, A2 arg2, A3 arg3) {
        return new Builder(() -> request.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> Builder<R> newBuilder(Functions.Func4<A1, A2, A3, A4, R> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return new Builder(() -> request.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> Builder<R> newBuilder(Functions.Func5<A1, A2, A3, A4, A5, R> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return new Builder(() -> request.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> Builder<R> newBuilder(Functions.Func6<A1, A2, A3, A4, A5, A6, R> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return new Builder(() -> request.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static Builder<Void> newBuilder(Functions.Proc request) {
        return new Builder<Void>(() -> request.apply());
    }

    public static <A1> Builder<Void> newBuilder(Functions.Proc1<A1> request, A1 arg1) {
        return new Builder<Void>(() -> request.apply(arg1));
    }

    public static <A1, A2> Builder<Void> newBuilder(Functions.Proc2<A1, A2> request, A1 arg1, A2 arg2) {
        return new Builder<Void>(() -> request.apply(arg1, arg2));
    }

    public static <A1, A2, A3> Builder<Void> newBuilder(Functions.Proc3<A1, A2, A3> request, A1 arg1, A2 arg2, A3 arg3) {
        return new Builder<Void>(() -> request.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> Builder<Void> newBuilder(Functions.Proc4<A1, A2, A3, A4> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return new Builder<Void>(() -> request.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> Builder<Void> newBuilder(Functions.Proc5<A1, A2, A3, A4, A5> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return new Builder<Void>(() -> request.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> Builder<Void> newBuilder(Functions.Proc6<A1, A2, A3, A4, A5, A6> request, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return new Builder<Void>(() -> request.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> Builder<R> newBuilder(String updateName, Class<R> resultClass, Object[] args) {
        return new Builder(UpdateOptions.newBuilder().setResultClass(resultClass).setUpdateName(updateName), args);
    }

    private UpdateWithStartWorkflowOperation(UpdateOptions<R> options, Functions.Proc updateRequest, Object[] updateArgs) {
        this.options = options;
        this.updateArgs = updateArgs;
        this.handle = new CompletableFuture();
        this.updateRequest = updateRequest;
    }

    WorkflowUpdateHandle<R> invoke(Functions.Proc workflowRequest) {
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.UPDATE_WITH_START, this);
        try {
            workflowRequest.apply();
            if (this.updateRequest != null) {
                this.updateRequest.apply();
            }
            this.stub.updateWithStart(this, this.workflowArgs);
            WorkflowUpdateHandle<R> workflowUpdateHandle = this.handle.get();
            return workflowUpdateHandle;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    void prepareUpdate(WorkflowStub stub, String updateName, Class resultClass, Type resultType, Object[] args) {
        this.setStub(stub);
        this.updateArgs = args;
        this.options = this.options.toBuilder().setUpdateName(updateName).setResultClass(resultClass).setResultType(resultType).build();
    }

    void prepareStart(WorkflowStub stub, Object[] args) {
        this.setStub(stub);
        this.workflowArgs = args;
    }

    public R getResult() throws ExecutionException, InterruptedException {
        return this.getUpdateHandle().get().getResultAsync().get();
    }

    public Future<WorkflowUpdateHandle<R>> getUpdateHandle() {
        return this.handle;
    }

    void setUpdateHandle(WorkflowUpdateHandle<R> updateHandle) {
        this.handle.complete(updateHandle);
    }

    public UpdateOptions<R> getOptions() {
        return this.options;
    }

    public Object[] getUpdateArgs() {
        return this.updateArgs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateWithStartWorkflowOperation{options=").append(this.options);
        if (this.updateRequest != null) {
            sb.append(", updateRequest=").append(this.updateRequest);
        }
        if (this.updateArgs != null) {
            sb.append(", updateArgs=").append(Arrays.toString(this.updateArgs));
        }
        return sb.toString();
    }

    private void setStub(WorkflowStub stub) {
        if (this.stub != null && stub != this.stub) {
            throw new IllegalArgumentException("UpdateWithStartWorkflowOperation invoked on different workflow stubs");
        }
        this.stub = stub;
    }

    boolean markInvoked() {
        return this.invoked.compareAndSet(false, true);
    }

    public static final class Builder<R> {
        private UpdateOptions.Builder<R> options;
        private Functions.Proc request;
        private Object[] args;

        private Builder() {
        }

        private Builder(UpdateOptions.Builder<R> options, Object[] args) {
            this.options = options;
            this.request = null;
            this.args = args;
        }

        private Builder(Functions.Proc request) {
            this.options = UpdateOptions.newBuilder();
            this.request = request;
        }

        public Builder<R> setWaitForStage(WorkflowUpdateStage waitForStage) {
            this.options.setWaitForStage(waitForStage);
            return this;
        }

        public Builder<R> setUpdateId(String updateId) {
            this.options.setUpdateId(updateId);
            return this;
        }

        public UpdateWithStartWorkflowOperation<R> build() {
            return new UpdateWithStartWorkflowOperation(this.options.build(), this.request, this.args);
        }
    }
}

