/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import com.uber.m3.tally.Scope;
import io.temporal.client.schedules.Schedule;
import io.temporal.client.schedules.ScheduleClient;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.client.schedules.ScheduleHandle;
import io.temporal.client.schedules.ScheduleHandleImpl;
import io.temporal.client.schedules.ScheduleListDescription;
import io.temporal.client.schedules.ScheduleOptions;
import io.temporal.common.interceptors.ScheduleClientCallsInterceptor;
import io.temporal.common.interceptors.ScheduleClientInterceptor;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.internal.client.RootScheduleClientInvoker;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.client.external.GenericWorkflowClientImpl;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

final class ScheduleClientImpl
implements ScheduleClient {
    private final WorkflowServiceStubs workflowServiceStubs;
    private final ScheduleClientOptions options;
    private final GenericWorkflowClient genericClient;
    private final Scope metricsScope;
    private final ScheduleClientCallsInterceptor scheduleClientCallsInvoker;
    private final List<ScheduleClientInterceptor> interceptors;

    public static ScheduleClient newInstance(WorkflowServiceStubs service, ScheduleClientOptions options) {
        WorkflowThreadMarker.enforceNonWorkflowThread();
        return (ScheduleClient)WorkflowThreadMarker.protectFromWorkflowThread((Object)new ScheduleClientImpl(service, options), ScheduleClient.class);
    }

    ScheduleClientImpl(WorkflowServiceStubs workflowServiceStubs, ScheduleClientOptions options) {
        this.workflowServiceStubs = workflowServiceStubs;
        this.options = options;
        this.metricsScope = workflowServiceStubs.getOptions().getMetricsScope().tagged(MetricsTag.defaultTags((String)options.getNamespace()));
        this.genericClient = new GenericWorkflowClientImpl(workflowServiceStubs, this.metricsScope);
        this.interceptors = options.getInterceptors();
        this.scheduleClientCallsInvoker = this.initializeClientInvoker();
    }

    private ScheduleClientCallsInterceptor initializeClientInvoker() {
        ScheduleClientCallsInterceptor scheduleClientInvoker = new RootScheduleClientInvoker(this.genericClient, this.options);
        for (ScheduleClientInterceptor clientInterceptor : this.interceptors) {
            scheduleClientInvoker = clientInterceptor.scheduleClientCallsInterceptor(scheduleClientInvoker);
        }
        return scheduleClientInvoker;
    }

    @Override
    public ScheduleHandle createSchedule(String scheduleID, Schedule schedule, ScheduleOptions options) {
        this.scheduleClientCallsInvoker.createSchedule(new ScheduleClientCallsInterceptor.CreateScheduleInput(scheduleID, schedule, options));
        return new ScheduleHandleImpl(this.scheduleClientCallsInvoker, scheduleID);
    }

    @Override
    public ScheduleHandle getHandle(String scheduleID) {
        return new ScheduleHandleImpl(this.scheduleClientCallsInvoker, scheduleID);
    }

    @Override
    public Stream<ScheduleListDescription> listSchedules() {
        return this.listSchedules(null, null);
    }

    @Override
    public Stream<ScheduleListDescription> listSchedules(@Nullable Integer pageSize) {
        return this.listSchedules(null, pageSize);
    }

    @Override
    public Stream<ScheduleListDescription> listSchedules(@Nullable String query, @Nullable Integer pageSize) {
        return this.scheduleClientCallsInvoker.listSchedules(new ScheduleClientCallsInterceptor.ListSchedulesInput(query, pageSize == null ? 100 : pageSize)).getStream();
    }
}

