/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.interceptors;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.update.v1.WaitPolicy;
import io.temporal.client.UpdateWithStartWorkflowOperation;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.common.Experimental;
import io.temporal.common.interceptors.Header;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Experimental
public interface WorkflowClientCallsInterceptor {
    public WorkflowStartOutput start(WorkflowStartInput var1);

    public WorkflowSignalOutput signal(WorkflowSignalInput var1);

    public WorkflowSignalWithStartOutput signalWithStart(WorkflowSignalWithStartInput var1);

    @Experimental
    public <R> WorkflowUpdateWithStartOutput<R> updateWithStart(WorkflowUpdateWithStartInput<R> var1);

    public <R> GetResultOutput<R> getResult(GetResultInput<R> var1) throws TimeoutException;

    public <R> GetResultAsyncOutput<R> getResultAsync(GetResultInput<R> var1);

    public <R> QueryOutput<R> query(QueryInput<R> var1);

    @Experimental
    public <R> WorkflowUpdateHandle<R> startUpdate(StartUpdateInput<R> var1);

    @Experimental
    public <R> PollWorkflowUpdateOutput<R> pollWorkflowUpdate(PollWorkflowUpdateInput<R> var1);

    public CancelOutput cancel(CancelInput var1);

    public TerminateOutput terminate(TerminateInput var1);

    public static final class TerminateOutput {
    }

    public static final class TerminateInput {
        private final WorkflowExecution workflowExecution;
        @Nullable
        private final String reason;
        private final Object[] details;

        public TerminateInput(WorkflowExecution workflowExecution, @Nullable String reason, Object[] details) {
            this.workflowExecution = workflowExecution;
            this.reason = reason;
            this.details = details;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public Object[] getDetails() {
            return this.details;
        }
    }

    public static final class CancelOutput {
    }

    @Experimental
    public static final class PollWorkflowUpdateOutput<R> {
        private final CompletableFuture<R> result;

        public PollWorkflowUpdateOutput(CompletableFuture<R> result) {
            this.result = result;
        }

        public CompletableFuture<R> getResult() {
            return this.result;
        }
    }

    @Experimental
    public static final class PollWorkflowUpdateInput<R> {
        private final WorkflowExecution workflowExecution;
        private long timeout;
        private TimeUnit timeoutUnit;
        private final Class<R> resultClass;
        private final Type resultType;
        private final String updateName;
        private final String updateId;

        public PollWorkflowUpdateInput(WorkflowExecution workflowExecution, String updateName, String updateId, Class<R> resultClass, Type resultType, long timeout, TimeUnit timeoutUnit) {
            this.workflowExecution = workflowExecution;
            this.updateName = updateName;
            this.updateId = updateId;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public TimeUnit getTimeoutUnit() {
            return this.timeoutUnit;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public String getUpdateName() {
            return this.updateName;
        }

        public String getUpdateId() {
            return this.updateId;
        }
    }

    @Experimental
    public static final class StartUpdateInput<R> {
        private final WorkflowExecution workflowExecution;
        private final Optional<String> workflowType;
        private final String updateName;
        private final Header header;
        private final Object[] arguments;
        private final Class<R> resultClass;
        private final Type resultType;
        private final String updateId;
        private final String firstExecutionRunId;
        private final WaitPolicy waitPolicy;

        public StartUpdateInput(WorkflowExecution workflowExecution, Optional<String> workflowType, String updateName, Header header, String updateId, Object[] arguments, Class<R> resultClass, Type resultType, String firstExecutionRunId, WaitPolicy waitPolicy) {
            this.workflowExecution = workflowExecution;
            this.workflowType = workflowType;
            this.header = header;
            this.updateId = updateId;
            this.updateName = updateName;
            this.arguments = arguments;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.firstExecutionRunId = firstExecutionRunId;
            this.waitPolicy = waitPolicy;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public Optional<String> getWorkflowType() {
            return this.workflowType;
        }

        public String getUpdateName() {
            return this.updateName;
        }

        public Header getHeader() {
            return this.header;
        }

        public String getUpdateId() {
            return this.updateId;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public String getFirstExecutionRunId() {
            return this.firstExecutionRunId;
        }

        public WaitPolicy getWaitPolicy() {
            return this.waitPolicy;
        }
    }

    public static final class CancelInput {
        private final WorkflowExecution workflowExecution;

        public CancelInput(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }
    }

    public static final class QueryOutput<R> {
        private final WorkflowExecutionStatus queryRejectedStatus;
        private final R result;

        public QueryOutput(WorkflowExecutionStatus queryRejectedStatus, R result) {
            this.queryRejectedStatus = queryRejectedStatus;
            this.result = result;
        }

        public boolean isQueryRejected() {
            return this.queryRejectedStatus != null;
        }

        public WorkflowExecutionStatus getQueryRejectedStatus() {
            return this.queryRejectedStatus;
        }

        public R getResult() {
            return this.result;
        }
    }

    public static final class QueryInput<R> {
        private final WorkflowExecution workflowExecution;
        private final String queryType;
        private final Header header;
        private final Object[] arguments;
        private final Class<R> resultClass;
        private final Type resultType;

        public QueryInput(WorkflowExecution workflowExecution, String queryType, Header header, Object[] arguments, Class<R> resultClass, Type resultType) {
            this.workflowExecution = workflowExecution;
            this.queryType = queryType;
            this.header = header;
            this.arguments = arguments;
            this.resultClass = resultClass;
            this.resultType = resultType;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public Header getHeader() {
            return this.header;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }
    }

    public static final class GetResultAsyncOutput<R> {
        private final CompletableFuture<R> result;

        public GetResultAsyncOutput(CompletableFuture<R> result) {
            this.result = result;
        }

        public CompletableFuture<R> getResult() {
            return this.result;
        }
    }

    public static final class GetResultOutput<R> {
        private final R result;

        public GetResultOutput(R result) {
            this.result = result;
        }

        public R getResult() {
            return this.result;
        }
    }

    public static final class GetResultInput<R> {
        private final WorkflowExecution workflowExecution;
        private final Optional<String> workflowType;
        private final long timeout;
        private final TimeUnit timeoutUnit;
        private final Class<R> resultClass;
        private final Type resultType;

        public GetResultInput(WorkflowExecution workflowExecution, Optional<String> workflowType, long timeout, TimeUnit timeoutUnit, Class<R> resultClass, Type resultType) {
            this.workflowExecution = workflowExecution;
            this.workflowType = workflowType;
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            this.resultClass = resultClass;
            this.resultType = resultType;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public Optional<String> getWorkflowType() {
            return this.workflowType;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public TimeUnit getTimeoutUnit() {
            return this.timeoutUnit;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }
    }

    public static final class WorkflowUpdateWithStartOutput<R> {
        private final WorkflowStartOutput workflowStartOutput;
        private final WorkflowUpdateHandle<R> updateHandle;

        public WorkflowUpdateWithStartOutput(WorkflowStartOutput workflowStartOutput, WorkflowUpdateHandle<R> updateHandle) {
            this.workflowStartOutput = workflowStartOutput;
            this.updateHandle = updateHandle;
        }

        public WorkflowStartOutput getWorkflowStartOutput() {
            return this.workflowStartOutput;
        }

        public WorkflowUpdateHandle<R> getUpdateHandle() {
            return this.updateHandle;
        }
    }

    public static final class WorkflowUpdateWithStartInput<R> {
        private final WorkflowStartInput workflowStartInput;
        private final UpdateWithStartWorkflowOperation<R> updateOperation;

        public WorkflowUpdateWithStartInput(WorkflowStartInput workflowStartInput, UpdateWithStartWorkflowOperation<R> updateOperation) {
            this.workflowStartInput = workflowStartInput;
            this.updateOperation = updateOperation;
        }

        public WorkflowStartInput getWorkflowStartInput() {
            return this.workflowStartInput;
        }

        public UpdateWithStartWorkflowOperation<R> getUpdateOperation() {
            return this.updateOperation;
        }
    }

    public static final class WorkflowSignalWithStartOutput {
        private final WorkflowStartOutput workflowStartOutput;

        public WorkflowSignalWithStartOutput(WorkflowStartOutput workflowStartOutput) {
            this.workflowStartOutput = workflowStartOutput;
        }

        public WorkflowStartOutput getWorkflowStartOutput() {
            return this.workflowStartOutput;
        }
    }

    public static final class WorkflowSignalWithStartInput {
        private final WorkflowStartInput workflowStartInput;
        private final String signalName;
        private final Object[] signalArguments;

        public WorkflowSignalWithStartInput(WorkflowStartInput workflowStartInput, String signalName, Object[] signalArguments) {
            this.workflowStartInput = workflowStartInput;
            this.signalName = signalName;
            this.signalArguments = signalArguments;
        }

        public WorkflowStartInput getWorkflowStartInput() {
            return this.workflowStartInput;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Object[] getSignalArguments() {
            return this.signalArguments;
        }
    }

    public static final class WorkflowSignalOutput {
    }

    public static final class WorkflowSignalInput {
        private final WorkflowExecution workflowExecution;
        private final String signalName;
        private final Header header;
        private final Object[] arguments;

        public WorkflowSignalInput(WorkflowExecution workflowExecution, String signalName, Header header, Object[] signalArguments) {
            this.workflowExecution = workflowExecution;
            this.signalName = signalName;
            this.header = header;
            this.arguments = signalArguments;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Header getHeader() {
            return this.header;
        }

        public Object[] getArguments() {
            return this.arguments;
        }
    }

    public static final class WorkflowStartOutput {
        @Nonnull
        private final WorkflowExecution workflowExecution;

        public WorkflowStartOutput(@Nonnull WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        @Nonnull
        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }
    }

    public static final class WorkflowStartInput {
        private final String workflowId;
        private final String workflowType;
        private final Header header;
        private final Object[] arguments;
        private final WorkflowOptions options;

        public WorkflowStartInput(@Nonnull String workflowId, @Nonnull String workflowType, @Nonnull Header header, @Nonnull Object[] arguments, @Nonnull WorkflowOptions options) {
            this.workflowId = workflowId;
            this.workflowType = workflowType;
            this.header = header;
            this.arguments = arguments;
            this.options = options;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public String getWorkflowType() {
            return this.workflowType;
        }

        public Header getHeader() {
            return this.header;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public WorkflowOptions getOptions() {
            return this.options;
        }
    }
}

