/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common.env;

import com.google.common.base.Joiner;
import io.temporal.workflow.WorkflowInit;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Optional<Constructor<?>> getConstructor(Class<?> clazz, List<Method> workflowMethod) {
        Optional<Constructor<?>> workflowInit = Optional.empty();
        Constructor<?> defaultConstructors = null;
        for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
            WorkflowInit wfInit = ctor.getAnnotation(WorkflowInit.class);
            if (wfInit == null) {
                if (ctor.getParameterCount() != 0 || !Modifier.isPublic(ctor.getModifiers())) continue;
                if (workflowInit.isPresent() || defaultConstructors != null) {
                    throw new IllegalArgumentException("Multiple constructors annotated with @WorkflowInit or a default constructor found: " + clazz.getName());
                }
                defaultConstructors = ctor;
                continue;
            }
            if (workflowMethod.size() != 1) {
                throw new IllegalArgumentException("Multiple interfaces implemented while using @WorkflowInit annotation. Only one is allowed: " + clazz.getName());
            }
            if (workflowInit.isPresent() || defaultConstructors != null) {
                throw new IllegalArgumentException("Multiple constructors annotated with @WorkflowInit or a default constructor found: " + clazz.getName());
            }
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new IllegalArgumentException("Constructor with @WorkflowInit annotation must be public: " + clazz.getName());
            }
            if (!Arrays.equals(ctor.getParameterTypes(), workflowMethod.get(0).getParameterTypes())) {
                throw new IllegalArgumentException("Constructor annotated with @WorkflowInit must have the same parameters as the workflow method: " + clazz.getName());
            }
            workflowInit = Optional.of(ctor);
        }
        if (!workflowInit.isPresent() && defaultConstructors == null) {
            throw new IllegalArgumentException("No default constructor or constructor annotated with @WorkflowInit found: " + clazz.getName());
        }
        return workflowInit;
    }

    public static String getMethodNameForStackTraceCutoff(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws RuntimeException {
        try {
            return clazz.getName() + "." + clazz.getMethod(methodName, parameterTypes).getName();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Reflection code that publishes the methods signatures is out of sync with actual method signatures. Class '" + clazz.getCanonicalName() + "' is expected to have method '" + methodName + "' with parameters {" + Joiner.on((String)", ").join((Object[])parameterTypes) + "}", e);
        }
    }
}

