/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.worker.tuning.SlotInfo;
import io.temporal.worker.tuning.SlotMarkUsedContext;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseContext;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotReserveContext;
import io.temporal.worker.tuning.SlotSupplier;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TrackingSlotSupplier<SI extends SlotInfo> {
    private final SlotSupplier<SI> inner;
    private final AtomicInteger issuedSlots = new AtomicInteger();
    private final Map<SlotPermit, SI> usedSlots = new ConcurrentHashMap<SlotPermit, SI>();
    private final Scope metricsScope;

    public TrackingSlotSupplier(SlotSupplier<SI> inner, Scope metricsScope) {
        this.inner = inner;
        this.metricsScope = metricsScope;
        this.publishSlotsMetric();
    }

    public SlotPermit reserveSlot(SlotReservationData dat) throws InterruptedException {
        SlotPermit p = this.inner.reserveSlot(this.createCtx(dat));
        this.issuedSlots.incrementAndGet();
        return p;
    }

    public Optional<SlotPermit> tryReserveSlot(SlotReservationData dat) {
        Optional<SlotPermit> p = this.inner.tryReserveSlot(this.createCtx(dat));
        if (p.isPresent()) {
            this.issuedSlots.incrementAndGet();
        }
        return p;
    }

    public void markSlotUsed(SI slotInfo, SlotPermit permit) {
        if (permit == null) {
            throw new IllegalArgumentException("Permit cannot be null when marking slot as used. This is an SDK bug.");
        }
        if (this.usedSlots.put(permit, slotInfo) != null) {
            throw new IllegalStateException("Slot is being marked used twice. This is an SDK bug.");
        }
        this.inner.markSlotUsed(new SlotMarkUsedContextImpl(this, slotInfo, permit));
        this.publishSlotsMetric();
    }

    public void releaseSlot(SlotReleaseReason reason, SlotPermit permit) {
        if (permit == null) {
            throw new IllegalArgumentException("Permit cannot be null when releasing a slot. This is an SDK bug.");
        }
        SlotInfo slotInfo = (SlotInfo)this.usedSlots.get(permit);
        this.inner.releaseSlot(new SlotReleaseContextImpl(this, reason, permit, slotInfo));
        this.issuedSlots.decrementAndGet();
        this.usedSlots.remove(permit);
        this.publishSlotsMetric();
    }

    public Optional<Integer> maximumSlots() {
        return this.inner.getMaximumSlots();
    }

    public int getIssuedSlots() {
        return this.issuedSlots.get();
    }

    Map<SlotPermit, SI> getUsedSlots() {
        return this.usedSlots;
    }

    private void publishSlotsMetric() {
        if (this.maximumSlots().isPresent()) {
            this.metricsScope.gauge("temporal_worker_task_slots_available").update((double)(this.maximumSlots().get() - this.usedSlots.size()));
        }
        this.metricsScope.gauge("temporal_worker_task_slots_used").update((double)this.usedSlots.size());
    }

    private SlotReserveContext<SI> createCtx(SlotReservationData dat) {
        return new SlotReserveContextImpl(dat.taskQueue, Collections.unmodifiableMap(this.usedSlots), dat.workerIdentity, dat.workerBuildId, this.issuedSlots);
    }

    private static class SlotReleaseContextImpl
    implements SlotReleaseContext<SI> {
        private final SlotPermit slotPermit;
        private final SlotReleaseReason reason;
        private final SI slotInfo;
        final /* synthetic */ TrackingSlotSupplier this$0;

        protected SlotReleaseContextImpl(SlotReleaseReason reason, SlotPermit slotPermit, SI slotInfo) {
            this.this$0 = var1_1;
            this.slotPermit = slotPermit;
            this.reason = reason;
            this.slotInfo = slotInfo;
        }

        @Override
        public SlotReleaseReason getSlotReleaseReason() {
            return this.reason;
        }

        @Override
        public SlotPermit getSlotPermit() {
            return this.slotPermit;
        }

        @Override
        public SI getSlotInfo() {
            return this.slotInfo;
        }
    }

    private static class SlotMarkUsedContextImpl
    implements SlotMarkUsedContext<SI> {
        private final SI slotInfo;
        private final SlotPermit slotPermit;
        final /* synthetic */ TrackingSlotSupplier this$0;

        protected SlotMarkUsedContextImpl(SI slotInfo, SlotPermit slotPermit) {
            this.this$0 = var1_1;
            this.slotInfo = slotInfo;
            this.slotPermit = slotPermit;
        }

        @Override
        public SI getSlotInfo() {
            return this.slotInfo;
        }

        @Override
        public SlotPermit getSlotPermit() {
            return this.slotPermit;
        }
    }

    private class SlotReserveContextImpl
    implements SlotReserveContext<SI> {
        private final String taskQueue;
        private final Map<SlotPermit, SI> usedSlots;
        private final String workerIdentity;
        private final String workerBuildId;
        private final AtomicInteger issuedSlots;

        private SlotReserveContextImpl(String taskQueue, Map<SlotPermit, SI> usedSlots, String workerIdentity, String workerBuildId, AtomicInteger issuedSlots) {
            this.taskQueue = taskQueue;
            this.usedSlots = usedSlots;
            this.workerIdentity = workerIdentity;
            this.workerBuildId = workerBuildId;
            this.issuedSlots = issuedSlots;
        }

        @Override
        public String getTaskQueue() {
            return this.taskQueue;
        }

        @Override
        public Map<SlotPermit, SI> getUsedSlots() {
            return this.usedSlots;
        }

        @Override
        public String getWorkerIdentity() {
            return this.workerIdentity;
        }

        @Override
        public String getWorkerBuildId() {
            return this.workerBuildId;
        }

        @Override
        public int getNumIssuedSlots() {
            return this.issuedSlots.get();
        }
    }
}

