/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.interceptors;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.Experimental;
import io.temporal.common.SearchAttributeUpdate;
import io.temporal.common.interceptors.Header;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.DynamicQueryHandler;
import io.temporal.workflow.DynamicSignalHandler;
import io.temporal.workflow.DynamicUpdateHandler;
import io.temporal.workflow.Functions;
import io.temporal.workflow.HandlerUnfinishedPolicy;
import io.temporal.workflow.NexusOperationExecution;
import io.temporal.workflow.NexusOperationOptions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.TimerOptions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Experimental
public interface WorkflowOutboundCallsInterceptor {
    public <R> ActivityOutput<R> executeActivity(ActivityInput<R> var1);

    public <R> LocalActivityOutput<R> executeLocalActivity(LocalActivityInput<R> var1);

    public <R> ChildWorkflowOutput<R> executeChildWorkflow(ChildWorkflowInput<R> var1);

    @Experimental
    public <R> ExecuteNexusOperationOutput<R> executeNexusOperation(ExecuteNexusOperationInput<R> var1);

    public Random newRandom();

    public SignalExternalOutput signalExternalWorkflow(SignalExternalInput var1);

    public CancelWorkflowOutput cancelWorkflow(CancelWorkflowInput var1);

    public void sleep(Duration var1);

    public boolean await(Duration var1, String var2, Supplier<Boolean> var3);

    public void await(String var1, Supplier<Boolean> var2);

    public Promise<Void> newTimer(Duration var1);

    public Promise<Void> newTimer(Duration var1, TimerOptions var2);

    public <R> R sideEffect(Class<R> var1, Type var2, Functions.Func<R> var3);

    public <R> R mutableSideEffect(String var1, Class<R> var2, Type var3, BiPredicate<R, R> var4, Functions.Func<R> var5);

    public int getVersion(String var1, int var2, int var3);

    public void continueAsNew(ContinueAsNewInput var1);

    public void registerQuery(RegisterQueryInput var1);

    public void registerSignalHandlers(RegisterSignalHandlersInput var1);

    @Experimental
    public void registerUpdateHandlers(RegisterUpdateHandlersInput var1);

    public void registerDynamicSignalHandler(RegisterDynamicSignalHandlerInput var1);

    public void registerDynamicQueryHandler(RegisterDynamicQueryHandlerInput var1);

    @Experimental
    public void registerDynamicUpdateHandler(RegisterDynamicUpdateHandlerInput var1);

    public UUID randomUUID();

    public void upsertSearchAttributes(Map<String, ?> var1);

    public void upsertTypedSearchAttributes(SearchAttributeUpdate<?> ... var1);

    public void upsertMemo(Map<String, Object> var1);

    public Scope getMetricsScope();

    public Object newChildThread(Runnable var1, boolean var2, String var3);

    public long currentTimeMillis();

    @Experimental
    public static final class RegisterDynamicUpdateHandlerInput {
        private final DynamicUpdateHandler handler;

        public RegisterDynamicUpdateHandlerInput(DynamicUpdateHandler handler) {
            this.handler = handler;
        }

        public DynamicUpdateHandler getHandler() {
            return this.handler;
        }
    }

    public static final class RegisterDynamicSignalHandlerInput {
        private final DynamicSignalHandler handler;

        public RegisterDynamicSignalHandlerInput(DynamicSignalHandler handler) {
            this.handler = handler;
        }

        public DynamicSignalHandler getHandler() {
            return this.handler;
        }
    }

    public static final class RegisterDynamicQueryHandlerInput {
        private final DynamicQueryHandler handler;

        public RegisterDynamicQueryHandlerInput(DynamicQueryHandler handler) {
            this.handler = handler;
        }

        public DynamicQueryHandler getHandler() {
            return this.handler;
        }
    }

    public static final class RegisterQueryInput {
        private final String queryType;
        private final String description;
        private final Class<?>[] argTypes;
        private final Type[] genericArgTypes;
        private final Functions.Func1<Object[], Object> callback;

        public RegisterQueryInput(String queryType, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Func1<Object[], Object> callback) {
            this.queryType = queryType;
            this.description = "";
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public RegisterQueryInput(String queryType, String description, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Func1<Object[], Object> callback) {
            this.queryType = queryType;
            this.description = description;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public String getQueryType() {
            return this.queryType;
        }

        @Experimental
        public String getDescription() {
            return this.description;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Type[] getGenericArgTypes() {
            return this.genericArgTypes;
        }

        public Functions.Func1<Object[], Object> getCallback() {
            return this.callback;
        }
    }

    @Experimental
    public static final class RegisterUpdateHandlersInput {
        private final List<UpdateRegistrationRequest> requests;

        public RegisterUpdateHandlersInput(List<UpdateRegistrationRequest> requests) {
            this.requests = requests;
        }

        public List<UpdateRegistrationRequest> getRequests() {
            return this.requests;
        }
    }

    @Experimental
    public static final class UpdateRegistrationRequest {
        private final String updateName;
        private final String description;
        private final HandlerUnfinishedPolicy unfinishedPolicy;
        private final Class<?>[] argTypes;
        private final Type[] genericArgTypes;
        private final Functions.Func1<Object[], Object> executeCallback;
        private final Functions.Proc1<Object[]> validateCallback;

        public UpdateRegistrationRequest(String updateName, HandlerUnfinishedPolicy unfinishedPolicy, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> validateCallback, Functions.Func1<Object[], Object> executeCallback) {
            this.updateName = updateName;
            this.description = "";
            this.unfinishedPolicy = unfinishedPolicy;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.validateCallback = validateCallback;
            this.executeCallback = executeCallback;
        }

        public UpdateRegistrationRequest(String updateName, String description, HandlerUnfinishedPolicy unfinishedPolicy, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> validateCallback, Functions.Func1<Object[], Object> executeCallback) {
            this.updateName = updateName;
            this.description = description;
            this.unfinishedPolicy = unfinishedPolicy;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.validateCallback = validateCallback;
            this.executeCallback = executeCallback;
        }

        public String getUpdateName() {
            return this.updateName;
        }

        @Experimental
        public String getDescription() {
            return this.description;
        }

        public HandlerUnfinishedPolicy getUnfinishedPolicy() {
            return this.unfinishedPolicy;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Type[] getGenericArgTypes() {
            return this.genericArgTypes;
        }

        public Functions.Proc1<Object[]> getValidateCallback() {
            return this.validateCallback;
        }

        public Functions.Func1<Object[], Object> getExecuteCallback() {
            return this.executeCallback;
        }
    }

    public static final class RegisterSignalHandlersInput {
        private final List<SignalRegistrationRequest> requests;

        public RegisterSignalHandlersInput(List<SignalRegistrationRequest> requests) {
            this.requests = requests;
        }

        public List<SignalRegistrationRequest> getRequests() {
            return this.requests;
        }
    }

    public static final class SignalRegistrationRequest {
        private final String signalType;
        private final String description;
        private final HandlerUnfinishedPolicy unfinishedPolicy;
        private final Class<?>[] argTypes;
        private final Type[] genericArgTypes;
        private final Functions.Proc1<Object[]> callback;

        public SignalRegistrationRequest(String signalType, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> callback) {
            this.signalType = signalType;
            this.description = "";
            this.unfinishedPolicy = HandlerUnfinishedPolicy.WARN_AND_ABANDON;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public SignalRegistrationRequest(String signalType, HandlerUnfinishedPolicy unfinishedPolicy, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> callback) {
            this.signalType = signalType;
            this.description = "";
            this.unfinishedPolicy = unfinishedPolicy;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public SignalRegistrationRequest(String signalType, String description, HandlerUnfinishedPolicy unfinishedPolicy, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> callback) {
            this.signalType = signalType;
            this.description = description;
            this.unfinishedPolicy = unfinishedPolicy;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public String getSignalType() {
            return this.signalType;
        }

        @Experimental
        public String getDescription() {
            return this.description;
        }

        public HandlerUnfinishedPolicy getUnfinishedPolicy() {
            return this.unfinishedPolicy;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Type[] getGenericArgTypes() {
            return this.genericArgTypes;
        }

        public Functions.Proc1<Object[]> getCallback() {
            return this.callback;
        }
    }

    public static final class ContinueAsNewInput {
        @Nullable
        private final String workflowType;
        @Nullable
        private final ContinueAsNewOptions options;
        private final Object[] args;
        private final Header header;

        public ContinueAsNewInput(@Nullable String workflowType, @Nullable ContinueAsNewOptions options, Object[] args, Header header) {
            this.workflowType = workflowType;
            this.options = options;
            this.args = args;
            this.header = header;
        }

        @Nullable
        public String getWorkflowType() {
            return this.workflowType;
        }

        @Nullable
        public ContinueAsNewOptions getOptions() {
            return this.options;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public static final class CancelWorkflowOutput {
        private final Promise<Void> result;

        public CancelWorkflowOutput(Promise<Void> result) {
            this.result = result;
        }

        public Promise<Void> getResult() {
            return this.result;
        }
    }

    public static final class CancelWorkflowInput {
        private final WorkflowExecution execution;

        public CancelWorkflowInput(WorkflowExecution execution) {
            this.execution = execution;
        }

        public WorkflowExecution getExecution() {
            return this.execution;
        }
    }

    public static final class SignalExternalOutput {
        private final Promise<Void> result;

        public SignalExternalOutput(Promise<Void> result) {
            this.result = result;
        }

        public Promise<Void> getResult() {
            return this.result;
        }
    }

    public static final class SignalExternalInput {
        private final WorkflowExecution execution;
        private final String signalName;
        private final Header header;
        private final Object[] args;

        public SignalExternalInput(WorkflowExecution execution, String signalName, Header header, Object[] args) {
            this.execution = execution;
            this.signalName = signalName;
            this.header = header;
            this.args = args;
        }

        public WorkflowExecution getExecution() {
            return this.execution;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Header getHeader() {
            return this.header;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    @Experimental
    public static final class ExecuteNexusOperationOutput<R> {
        private final Promise<R> result;
        private final Promise<NexusOperationExecution> operationExecution;

        public ExecuteNexusOperationOutput(Promise<R> result, Promise<NexusOperationExecution> operationExecution) {
            this.result = result;
            this.operationExecution = operationExecution;
        }

        public Promise<R> getResult() {
            return this.result;
        }

        public Promise<NexusOperationExecution> getOperationExecution() {
            return this.operationExecution;
        }
    }

    @Experimental
    public static final class ExecuteNexusOperationInput<R> {
        private final String endpoint;
        private final String service;
        private final String operation;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object arg;
        private final NexusOperationOptions options;
        private final Map<String, String> headers;

        public ExecuteNexusOperationInput(String endpoint, String service, String operation, Class<R> resultClass, Type resultType, Object arg, NexusOperationOptions options, Map<String, String> headers) {
            this.endpoint = endpoint;
            this.service = service;
            this.operation = operation;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.arg = arg;
            this.options = options;
            this.headers = headers.entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).toLowerCase(), Map.Entry::getValue, (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
        }

        public String getService() {
            return this.service;
        }

        public String getOperation() {
            return this.operation;
        }

        public Object getArg() {
            return this.arg;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public NexusOperationOptions getOptions() {
            return this.options;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    public static final class ChildWorkflowOutput<R> {
        private final Promise<R> result;
        private final Promise<WorkflowExecution> workflowExecution;

        public ChildWorkflowOutput(Promise<R> result, Promise<WorkflowExecution> workflowExecution) {
            this.result = result;
            this.workflowExecution = workflowExecution;
        }

        public Promise<R> getResult() {
            return this.result;
        }

        public Promise<WorkflowExecution> getWorkflowExecution() {
            return this.workflowExecution;
        }
    }

    public static final class ChildWorkflowInput<R> {
        private final String workflowId;
        private final String workflowType;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object[] args;
        private final ChildWorkflowOptions options;
        private final Header header;

        public ChildWorkflowInput(String workflowId, String workflowType, Class<R> resultClass, Type resultType, Object[] args, ChildWorkflowOptions options, Header header) {
            this.workflowId = workflowId;
            this.workflowType = workflowType;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.args = args;
            this.options = options;
            this.header = header;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public String getWorkflowType() {
            return this.workflowType;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public ChildWorkflowOptions getOptions() {
            return this.options;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public static final class LocalActivityOutput<R> {
        private final Promise<R> result;

        public LocalActivityOutput(Promise<R> result) {
            this.result = result;
        }

        public Promise<R> getResult() {
            return this.result;
        }
    }

    public static final class LocalActivityInput<R> {
        private final String activityName;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object[] args;
        private final LocalActivityOptions options;
        private final Header header;

        public LocalActivityInput(String activityName, Class<R> resultClass, Type resultType, Object[] args, LocalActivityOptions options, Header header) {
            this.activityName = activityName;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.args = args;
            this.options = options;
            this.header = header;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public LocalActivityOptions getOptions() {
            return this.options;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public static final class ActivityOutput<R> {
        private final String activityId;
        private final Promise<R> result;

        public ActivityOutput(String activityId, Promise<R> result) {
            this.activityId = activityId;
            this.result = result;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public Promise<R> getResult() {
            return this.result;
        }
    }

    public static final class ActivityInput<R> {
        private final String activityName;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object[] args;
        private final ActivityOptions options;
        private final Header header;

        public ActivityInput(String activityName, Class<R> resultClass, Type resultType, Object[] args, ActivityOptions options, Header header) {
            this.activityName = activityName;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.args = args;
            this.options = options;
            this.header = header;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public ActivityOptions getOptions() {
            return this.options;
        }

        public Header getHeader() {
            return this.header;
        }
    }
}

