/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.WorkflowUpdateException;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.common.Experimental;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Experimental
public final class CompletedWorkflowUpdateHandleImpl<T>
implements WorkflowUpdateHandle<T> {
    private final String id;
    private final WorkflowExecution execution;
    private final WorkflowUpdateException exception;
    private final T result;

    public CompletedWorkflowUpdateHandleImpl(String id, WorkflowExecution execution, T result) {
        this.id = id;
        this.execution = execution;
        this.result = result;
        this.exception = null;
    }

    public CompletedWorkflowUpdateHandleImpl(String id, WorkflowExecution execution, WorkflowUpdateException ex) {
        this.id = id;
        this.execution = execution;
        this.exception = ex;
        this.result = null;
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public T getResult() {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    @Override
    public T getResult(long timeout, TimeUnit unit) {
        return this.getResult();
    }

    @Override
    public CompletableFuture<T> getResultAsync() {
        if (this.exception != null) {
            CompletableFuture result = new CompletableFuture();
            result.completeExceptionally(this.exception);
            return result;
        }
        return CompletableFuture.completedFuture(this.result);
    }

    @Override
    public CompletableFuture<T> getResultAsync(long timeout, TimeUnit unit) {
        return this.getResultAsync();
    }
}

