/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.nexus;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.nexusrpc.FailureInfo;
import io.nexusrpc.OperationUnsuccessfulException;
import io.nexusrpc.Serializer;
import io.nexusrpc.handler.HandlerInputContent;
import io.nexusrpc.handler.HandlerResultContent;
import io.nexusrpc.handler.OperationCancelDetails;
import io.nexusrpc.handler.OperationContext;
import io.nexusrpc.handler.OperationHandlerException;
import io.nexusrpc.handler.OperationMethodCanceller;
import io.nexusrpc.handler.OperationMiddleware;
import io.nexusrpc.handler.OperationStartDetails;
import io.nexusrpc.handler.OperationStartResult;
import io.nexusrpc.handler.ServiceHandler;
import io.nexusrpc.handler.ServiceImplInstance;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.nexus.v1.CancelOperationRequest;
import io.temporal.api.nexus.v1.CancelOperationResponse;
import io.temporal.api.nexus.v1.Failure;
import io.temporal.api.nexus.v1.HandlerError;
import io.temporal.api.nexus.v1.Link;
import io.temporal.api.nexus.v1.Request;
import io.temporal.api.nexus.v1.Response;
import io.temporal.api.nexus.v1.StartOperationRequest;
import io.temporal.api.nexus.v1.StartOperationResponse;
import io.temporal.api.nexus.v1.UnsuccessfulOperationError;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowException;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.failure.ApplicationFailure;
import io.temporal.internal.common.NexusUtil;
import io.temporal.internal.nexus.CurrentNexusOperationContext;
import io.temporal.internal.nexus.NexusOperationContextImpl;
import io.temporal.internal.nexus.PayloadSerializer;
import io.temporal.internal.nexus.RootNexusOperationOutboundCallsInterceptor;
import io.temporal.internal.nexus.TemporalInterceptorMiddleware;
import io.temporal.internal.worker.NexusTask;
import io.temporal.internal.worker.NexusTaskHandler;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.worker.TypeAlreadyRegisteredException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusTaskHandlerImpl
implements NexusTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(NexusTaskHandlerImpl.class);
    private final DataConverter dataConverter;
    private final String namespace;
    private final String taskQueue;
    private final WorkflowClient client;
    private ServiceHandler serviceHandler;
    private final Map<String, ServiceImplInstance> serviceImplInstances = Collections.synchronizedMap(new HashMap());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final WorkerInterceptor[] interceptors;
    private final TemporalInterceptorMiddleware nexusServiceInterceptor;

    public NexusTaskHandlerImpl(@Nonnull WorkflowClient client, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull DataConverter dataConverter, @Nonnull WorkerInterceptor[] interceptors) {
        this.client = Objects.requireNonNull(client);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.interceptors = Objects.requireNonNull(interceptors);
        this.nexusServiceInterceptor = new TemporalInterceptorMiddleware(interceptors);
    }

    @Override
    public boolean start() {
        if (this.serviceImplInstances.isEmpty()) {
            return false;
        }
        ServiceHandler.Builder serviceHandlerBuilder = ServiceHandler.newBuilder().setSerializer((Serializer)new PayloadSerializer(this.dataConverter));
        this.serviceImplInstances.forEach((name, instance) -> serviceHandlerBuilder.addInstance(instance));
        serviceHandlerBuilder.addOperationMiddleware((OperationMiddleware)this.nexusServiceInterceptor);
        this.serviceHandler = serviceHandlerBuilder.build();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NexusTaskHandler.Result handle(NexusTask task, Scope metricsScope) throws TimeoutException {
        NexusTaskHandler.Result result;
        Request request = task.getResponse().getRequest();
        Map<String, String> headers = request.getHeaderMap();
        if (headers == null) {
            headers = Collections.emptyMap();
        }
        OperationContext.Builder ctx = OperationContext.newBuilder();
        headers.forEach((arg_0, arg_1) -> ((OperationContext.Builder)ctx).putHeader(arg_0, arg_1));
        OperationMethodCanceller canceller = new OperationMethodCanceller();
        ctx.setMethodCanceller(canceller);
        ScheduledFuture<?> timeoutTask = null;
        AtomicBoolean timedOut = new AtomicBoolean(false);
        try {
            String timeoutString = (String)ctx.getHeaders().get("Request-Timeout");
            if (timeoutString != null) {
                try {
                    Duration timeout = NexusUtil.parseRequestTimeout(timeoutString);
                    timeoutTask = this.scheduler.schedule(() -> {
                        timedOut.set(true);
                        canceller.cancel("timeout");
                    }, timeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (IllegalArgumentException e) {
                    NexusTaskHandler.Result result2 = new NexusTaskHandler.Result(HandlerError.newBuilder().setErrorType(OperationHandlerException.ErrorType.BAD_REQUEST.toString()).setFailure(Failure.newBuilder().setMessage("cannot parse request timeout").build()).build());
                    if (timedOut.get()) {
                        throw new TimeoutException("Nexus task completed after timeout.");
                    }
                    canceller.cancel("");
                    if (timeoutTask != null) {
                        timeoutTask.cancel(false);
                    }
                    CurrentNexusOperationContext.unset();
                    return result2;
                }
            }
            CurrentNexusOperationContext.set(new NexusOperationContextImpl(this.namespace, this.taskQueue, this.client, new RootNexusOperationOutboundCallsInterceptor(metricsScope)));
            switch (request.getVariantCase()) {
                case START_OPERATION: {
                    StartOperationResponse startResponse = this.handleStartOperation(ctx, request.getStartOperation());
                    NexusTaskHandler.Result result3 = new NexusTaskHandler.Result(Response.newBuilder().setStartOperation(startResponse).build());
                    return result3;
                }
                case CANCEL_OPERATION: {
                    CancelOperationResponse cancelResponse = this.handleCancelledOperation(ctx, request.getCancelOperation());
                    NexusTaskHandler.Result result4 = new NexusTaskHandler.Result(Response.newBuilder().setCancelOperation(cancelResponse).build());
                    return result4;
                }
            }
            NexusTaskHandler.Result result5 = new NexusTaskHandler.Result(HandlerError.newBuilder().setErrorType(OperationHandlerException.ErrorType.NOT_IMPLEMENTED.toString()).setFailure(Failure.newBuilder().setMessage("unknown request type").build()).build());
            return result5;
        }
        catch (OperationHandlerException e) {
            result = new NexusTaskHandler.Result(HandlerError.newBuilder().setErrorType(e.getErrorType().toString()).setFailure(this.createFailure(e.getFailureInfo())).build());
            return result;
        }
        catch (Throwable e) {
            result = new NexusTaskHandler.Result(HandlerError.newBuilder().setErrorType(OperationHandlerException.ErrorType.INTERNAL.toString()).setFailure(Failure.newBuilder().setMessage(e.toString()).build()).build());
            return result;
        }
        finally {
            if (timedOut.get()) {
                throw new TimeoutException("Nexus task completed after timeout.");
            }
            canceller.cancel("");
            if (timeoutTask != null) {
                timeoutTask.cancel(false);
            }
            CurrentNexusOperationContext.unset();
        }
    }

    private Failure createFailure(FailureInfo failInfo) {
        Failure.Builder failure = Failure.newBuilder();
        if (failInfo.getMessage() != null) {
            failure.setMessage(failInfo.getMessage());
        }
        if (failInfo.getDetailsJson() != null) {
            failure.setDetails(ByteString.copyFromUtf8((String)failInfo.getDetailsJson()));
        }
        if (!failInfo.getMetadata().isEmpty()) {
            failure.putAllMetadata(failInfo.getMetadata());
        }
        return failure.build();
    }

    private void cancelOperation(OperationContext context, OperationCancelDetails details) {
        try {
            this.serviceHandler.cancelOperation(context, details);
        }
        catch (Throwable e) {
            Throwable failure = CheckedExceptionWrapper.unwrap((Throwable)e);
            log.warn("Nexus cancel operation failure. Service={}, Operation={}", new Object[]{context.getService(), context.getOperation(), failure});
            throw e;
        }
    }

    private CancelOperationResponse handleCancelledOperation(OperationContext.Builder ctx, CancelOperationRequest task) {
        ctx.setService(task.getService()).setOperation(task.getOperation());
        OperationCancelDetails operationCancelDetails = OperationCancelDetails.newBuilder().setOperationId(task.getOperationId()).build();
        try {
            this.cancelOperation(ctx.build(), operationCancelDetails);
        }
        catch (Throwable failure) {
            this.convertKnownFailures(failure);
        }
        return CancelOperationResponse.newBuilder().build();
    }

    private void convertKnownFailures(Throwable e) {
        Throwable failure = CheckedExceptionWrapper.unwrap((Throwable)e);
        if (failure instanceof ApplicationFailure) {
            if (((ApplicationFailure)failure).isNonRetryable()) {
                throw new OperationHandlerException(OperationHandlerException.ErrorType.BAD_REQUEST, failure.getMessage());
            }
            throw new OperationHandlerException(OperationHandlerException.ErrorType.INTERNAL, failure.getMessage());
        }
        if (failure instanceof WorkflowException) {
            throw new OperationHandlerException(OperationHandlerException.ErrorType.BAD_REQUEST, failure.getMessage());
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        throw failure instanceof RuntimeException ? (RuntimeException)failure : new RuntimeException(failure);
    }

    private OperationStartResult<HandlerResultContent> startOperation(OperationContext context, OperationStartDetails details, HandlerInputContent input) throws OperationUnsuccessfulException {
        try {
            return this.serviceHandler.startOperation(context, details, input);
        }
        catch (Throwable e) {
            Throwable ex = CheckedExceptionWrapper.unwrap((Throwable)e);
            log.warn("Nexus start operation failure. Service={}, Operation={}", new Object[]{context.getService(), context.getOperation(), ex});
            throw e;
        }
    }

    private StartOperationResponse handleStartOperation(OperationContext.Builder ctx, StartOperationRequest task) {
        ctx.setService(task.getService()).setOperation(task.getOperation());
        OperationStartDetails.Builder operationStartDetails = OperationStartDetails.newBuilder().setCallbackUrl(task.getCallback()).setRequestId(task.getRequestId());
        task.getCallbackHeaderMap().forEach((arg_0, arg_1) -> ((OperationStartDetails.Builder)operationStartDetails).putCallbackHeader(arg_0, arg_1));
        task.getLinksList().forEach(link -> {
            try {
                operationStartDetails.addLink(NexusUtil.nexusProtoLinkToLink(link));
            }
            catch (URISyntaxException e) {
                log.error("failed to parse link url: " + link.getUrl(), (Throwable)e);
                throw new OperationHandlerException(OperationHandlerException.ErrorType.BAD_REQUEST, "Invalid link URL: " + link.getUrl(), (Throwable)e);
            }
        });
        HandlerInputContent.Builder input = HandlerInputContent.newBuilder().setDataStream(task.getPayload().toByteString().newInput());
        StartOperationResponse.Builder startResponseBuilder = StartOperationResponse.newBuilder();
        try {
            OperationStartResult<HandlerResultContent> result = this.startOperation(ctx.build(), operationStartDetails.build(), input.build());
            if (result.isSync()) {
                startResponseBuilder.setSyncSuccess(StartOperationResponse.Sync.newBuilder().setPayload(Payload.parseFrom((byte[])((HandlerResultContent)result.getSyncResult()).getDataBytes())).build());
            } else {
                startResponseBuilder.setAsyncSuccess(StartOperationResponse.Async.newBuilder().setOperationId(result.getAsyncOperationId()).addAllLinks((Iterable)result.getLinks().stream().map(link -> Link.newBuilder().setType(link.getType()).setUrl(link.getUri().toString()).build()).collect(Collectors.toList())).build());
            }
        }
        catch (OperationUnsuccessfulException e) {
            startResponseBuilder.setOperationError(UnsuccessfulOperationError.newBuilder().setOperationState(e.getState().toString().toLowerCase()).setFailure(this.createFailure(e.getFailureInfo())).build());
        }
        catch (Throwable failure) {
            this.convertKnownFailures(failure);
        }
        return startResponseBuilder.build();
    }

    public void registerNexusServiceImplementations(Object[] nexusServiceImplementation) {
        for (Object nexusService : nexusServiceImplementation) {
            this.registerNexusService(nexusService);
        }
    }

    private void registerNexusService(Object nexusService) {
        if (nexusService instanceof Class) {
            throw new IllegalArgumentException("Nexus service object instance expected, not the class");
        }
        ServiceImplInstance instance = ServiceImplInstance.fromInstance((Object)nexusService);
        if (this.serviceImplInstances.put(instance.getDefinition().getName(), instance) != null) {
            throw new TypeAlreadyRegisteredException(instance.getDefinition().getName(), "\"" + instance.getDefinition().getName() + "\" service type is already registered with the worker");
        }
    }

    public CompletionStage<Void> shutdown(ShutdownManager shutdownManager, boolean unused) {
        return shutdownManager.shutdownExecutorNow(this.scheduler, "NexusTaskHandlerImpl#scheduler", Duration.ofSeconds(5L));
    }
}

