/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.common.Experimental;
import java.time.Duration;
import java.util.Objects;

@Experimental
public final class NexusOperationOptions {
    private static final NexusOperationOptions DEFAULT_INSTANCE = NexusOperationOptions.newBuilder().build();
    private Duration scheduleToCloseTimeout;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(NexusOperationOptions options) {
        return new Builder(options);
    }

    public static NexusOperationOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private NexusOperationOptions(Duration scheduleToCloseTimeout) {
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NexusOperationOptions that = (NexusOperationOptions)o;
        return Objects.equals(this.scheduleToCloseTimeout, that.scheduleToCloseTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleToCloseTimeout);
    }

    public String toString() {
        return "NexusOperationOptions{scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + '}';
    }

    public static final class Builder {
        private Duration scheduleToCloseTimeout;

        public Builder setScheduleToCloseTimeout(Duration scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        private Builder() {
        }

        private Builder(NexusOperationOptions options) {
            if (options == null) {
                return;
            }
            this.scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
        }

        public NexusOperationOptions build() {
            return new NexusOperationOptions(this.scheduleToCloseTimeout);
        }

        public Builder mergeNexusOperationOptions(NexusOperationOptions override) {
            if (override == null) {
                return this;
            }
            this.scheduleToCloseTimeout = override.scheduleToCloseTimeout == null ? this.scheduleToCloseTimeout : override.scheduleToCloseTimeout;
            return this;
        }
    }
}

