/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.Defaults;
import io.nexusrpc.handler.HandlerException;
import io.nexusrpc.handler.ServiceImplInstance;
import io.temporal.api.common.v1.Callback;
import io.temporal.api.common.v1.Link;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.enums.v1.WorkflowIdConflictPolicy;
import io.temporal.api.nexus.v1.Link;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.client.OnConflictOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.common.metadata.POJOActivityMethodMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import io.temporal.internal.client.NexusStartWorkflowRequest;
import io.temporal.internal.common.LinkConverter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalUtils {
    public static String TEMPORAL_RESERVED_PREFIX = "__temporal_";
    private static final Logger log = LoggerFactory.getLogger(InternalUtils.class);
    private static String QUERY_TYPE_STACK_TRACE = "__stack_trace";
    private static String ENHANCED_QUERY_TYPE_STACK_TRACE = "__enhanced_stack_trace";

    public static TaskQueue createStickyTaskQueue(String stickyTaskQueueName, String normalTaskQueueName) {
        return TaskQueue.newBuilder().setName(stickyTaskQueueName).setKind(TaskQueueKind.TASK_QUEUE_KIND_STICKY).setNormalName(normalTaskQueueName).build();
    }

    public static TaskQueue createNormalTaskQueue(String taskQueueName) {
        return TaskQueue.newBuilder().setName(taskQueueName).setKind(TaskQueueKind.TASK_QUEUE_KIND_NORMAL).build();
    }

    public static Object getValueOrDefault(Object value, Class<?> valueClass) {
        if (value != null) {
            return value;
        }
        return Defaults.defaultValue(valueClass);
    }

    public static WorkflowStub createNexusBoundStub(WorkflowStub stub, NexusStartWorkflowRequest request) {
        if (!stub.getOptions().isPresent()) {
            throw new IllegalArgumentException("Options are expected to be set on the stub");
        }
        WorkflowOptions options = stub.getOptions().get();
        if (options.getWorkflowId() == null) {
            throw new IllegalArgumentException("WorkflowId is expected to be set on WorkflowOptions when used with Nexus");
        }
        Map headers = request.getCallbackHeaders().entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).toLowerCase(), Map.Entry::getValue, (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
        if (!headers.containsKey("Nexus-Operation-Id")) {
            headers.put("Nexus-Operation-Id".toLowerCase(), options.getWorkflowId());
        }
        if (!headers.containsKey("Nexus-Operation-Token")) {
            headers.put("Nexus-Operation-Token".toLowerCase(), options.getWorkflowId());
        }
        WorkflowOptions.Builder nexusWorkflowOptions = WorkflowOptions.newBuilder(options).setRequestId(request.getRequestId()).setCompletionCallbacks(Arrays.asList(Callback.newBuilder().setNexus(Callback.Nexus.newBuilder().setUrl(request.getCallbackUrl()).putAllHeader(headers).build()).build()));
        if (options.getTaskQueue() == null) {
            nexusWorkflowOptions.setTaskQueue(request.getTaskQueue());
        }
        if (request.getLinks() != null) {
            nexusWorkflowOptions.setLinks(request.getLinks().stream().map(link -> {
                if (Link.WorkflowEvent.getDescriptor().getFullName().equals(link.getType())) {
                    Link nexusLink = Link.newBuilder().setType(link.getType()).setUrl(link.getUri().toString()).build();
                    return LinkConverter.nexusLinkToWorkflowEvent(nexusLink);
                }
                log.warn("ignoring unsupported link data type: {}", (Object)link.getType());
                return null;
            }).filter(link -> link != null).collect(Collectors.toList()));
        }
        nexusWorkflowOptions.setOnConflictOptions(OnConflictOptions.newBuilder().setAttachRequestId(true).setAttachLinks(true).setAttachCompletionCallbacks(true).build());
        if (Objects.equals(WorkflowIdConflictPolicy.WORKFLOW_ID_CONFLICT_POLICY_USE_EXISTING, options.getWorkflowIdConflictPolicy())) {
            throw new HandlerException(HandlerException.ErrorType.INTERNAL, (Throwable)new IllegalArgumentException("Workflow ID conflict policy UseExisting is not supported for Nexus WorkflowRunOperation."), HandlerException.RetryBehavior.NON_RETRYABLE);
        }
        return stub.newInstance(nexusWorkflowOptions.build());
    }

    public static void checkMethodName(POJOWorkflowMethodMetadata methodMetadata) {
        if (methodMetadata.getName().startsWith(TEMPORAL_RESERVED_PREFIX)) {
            throw new IllegalArgumentException(methodMetadata.getType().toString().toLowerCase() + " name \"" + methodMetadata.getName() + "\" must not start with \"" + TEMPORAL_RESERVED_PREFIX + "\"");
        }
        if (methodMetadata.getType().equals((Object)WorkflowMethodType.QUERY) && (methodMetadata.getName().equals(QUERY_TYPE_STACK_TRACE) || methodMetadata.getName().equals(ENHANCED_QUERY_TYPE_STACK_TRACE))) {
            throw new IllegalArgumentException("Query method name \"" + methodMetadata.getName() + "\" is reserved for internal use");
        }
    }

    public static void checkMethodName(POJOActivityMethodMetadata methodMetadata) {
        if (methodMetadata.getActivityTypeName().startsWith(TEMPORAL_RESERVED_PREFIX)) {
            throw new IllegalArgumentException("Activity name \"" + methodMetadata.getActivityTypeName() + "\" must not start with \"" + TEMPORAL_RESERVED_PREFIX + "\"");
        }
    }

    private InternalUtils() {
    }

    public static void checkMethodName(ServiceImplInstance instance) {
        if (instance.getDefinition().getName().startsWith(TEMPORAL_RESERVED_PREFIX)) {
            throw new IllegalArgumentException("Service name \"" + instance.getDefinition().getName() + "\" must not start with \"" + TEMPORAL_RESERVED_PREFIX + "\"");
        }
        for (String operationName : instance.getDefinition().getOperations().keySet()) {
            if (!operationName.startsWith(TEMPORAL_RESERVED_PREFIX)) continue;
            throw new IllegalArgumentException("Operation name \"" + operationName + "\" must not start with \"" + TEMPORAL_RESERVED_PREFIX + "\"");
        }
    }
}

