/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import io.temporal.api.command.v1.Command;
import io.temporal.api.protocol.v1.Message;
import io.temporal.api.query.v1.WorkflowQueryResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WorkflowTaskResult {
    private final List<Command> commands;
    private final List<Message> messages;
    private final boolean finalCommand;
    private final Map<String, WorkflowQueryResult> queryResults;
    private final boolean forceWorkflowTask;
    private final int nonfirstLocalActivityAttempts;
    private final List<Integer> sdkFlags;
    private final String writeSdkName;
    private final String writeSdkVersion;

    public static Builder newBuilder() {
        return new Builder();
    }

    private WorkflowTaskResult(List<Command> commands, List<Message> messages, Map<String, WorkflowQueryResult> queryResults, boolean finalCommand, boolean forceWorkflowTask, int nonfirstLocalActivityAttempts, List<Integer> sdkFlags, String writeSdkName, String writeSdkVersion) {
        this.commands = commands;
        this.messages = messages;
        this.nonfirstLocalActivityAttempts = nonfirstLocalActivityAttempts;
        if (forceWorkflowTask && finalCommand) {
            throw new IllegalArgumentException("both forceWorkflowTask and finalCommand are true");
        }
        this.queryResults = queryResults;
        this.finalCommand = finalCommand;
        this.forceWorkflowTask = forceWorkflowTask;
        this.sdkFlags = sdkFlags;
        this.writeSdkName = writeSdkName;
        this.writeSdkVersion = writeSdkVersion;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Map<String, WorkflowQueryResult> getQueryResults() {
        return this.queryResults;
    }

    public boolean isFinalCommand() {
        return this.finalCommand;
    }

    public boolean isForceWorkflowTask() {
        return this.forceWorkflowTask;
    }

    public int getNonfirstLocalActivityAttempts() {
        return this.nonfirstLocalActivityAttempts;
    }

    public List<Integer> getSdkFlags() {
        return this.sdkFlags;
    }

    public String getWriteSdkName() {
        return this.writeSdkName;
    }

    public String getWriteSdkVersion() {
        return this.writeSdkVersion;
    }

    public static final class Builder {
        private List<Command> commands;
        private List<Message> messages;
        private boolean finalCommand;
        private Map<String, WorkflowQueryResult> queryResults;
        private boolean forceWorkflowTask;
        private int nonfirstLocalActivityAttempts;
        private List<Integer> sdkFlags;
        private String writeSdkName;
        private String writeSdkVersion;

        public Builder setCommands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public Builder setMessages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Builder setFinalCommand(boolean finalCommand) {
            this.finalCommand = finalCommand;
            return this;
        }

        public Builder setQueryResults(Map<String, WorkflowQueryResult> queryResults) {
            this.queryResults = queryResults;
            return this;
        }

        public Builder setForceWorkflowTask(boolean forceWorkflowTask) {
            this.forceWorkflowTask = forceWorkflowTask;
            return this;
        }

        public Builder setNonfirstLocalActivityAttempts(int nonfirstLocalActivityAttempts) {
            this.nonfirstLocalActivityAttempts = nonfirstLocalActivityAttempts;
            return this;
        }

        public Builder setSdkFlags(List<Integer> sdkFlags) {
            this.sdkFlags = sdkFlags;
            return this;
        }

        public Builder setWriteSdkName(String writeSdkName) {
            this.writeSdkName = writeSdkName;
            return this;
        }

        public Builder setWriteSdkVersion(String writeSdkVersion) {
            this.writeSdkVersion = writeSdkVersion;
            return this;
        }

        public WorkflowTaskResult build() {
            return new WorkflowTaskResult(this.commands == null ? Collections.emptyList() : this.commands, this.messages == null ? Collections.emptyList() : this.messages, this.queryResults == null ? Collections.emptyMap() : this.queryResults, this.finalCommand, this.forceWorkflowTask, this.nonfirstLocalActivityAttempts, this.sdkFlags == null ? Collections.emptyList() : this.sdkFlags, this.writeSdkName, this.writeSdkVersion);
        }
    }
}

