/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineBase;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.workflow.Functions;
import javax.annotation.Nullable;

class EntityStateMachineInitialCommand<State, ExplicitEvent, Data>
extends EntityStateMachineBase<State, ExplicitEvent, Data> {
    private CancellableCommand command;
    private long initialCommandEventId;

    public EntityStateMachineInitialCommand(StateMachineDefinition<State, ExplicitEvent, Data> stateMachineDefinition, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        this(stateMachineDefinition, commandSink, stateMachineSink, null);
    }

    public EntityStateMachineInitialCommand(StateMachineDefinition<State, ExplicitEvent, Data> stateMachineDefinition, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink, @Nullable String entityName) {
        super(stateMachineDefinition, commandSink, stateMachineSink, entityName);
    }

    protected final void addCommand(Command command) {
        if (command.getCommandType() == CommandType.COMMAND_TYPE_UNSPECIFIED) {
            throw new IllegalArgumentException("unspecified command type");
        }
        this.command = new CancellableCommand(command, this);
        this.commandSink.apply(this.command);
    }

    protected final void cancelCommand() {
        if (this.command != null) {
            this.command.cancel();
        }
    }

    @Override
    public WorkflowStateMachines.HandleEventStatus handleEvent(HistoryEvent event, boolean hasNextEvent) {
        if (WorkflowExecutionUtils.isCommandEvent(event)) {
            this.command = null;
        }
        return super.handleEvent(event, hasNextEvent);
    }

    protected long getInitialCommandEventId() {
        return this.initialCommandEventId;
    }

    protected void setInitialCommandEventId() {
        this.initialCommandEventId = this.currentEvent.getEventId();
    }
}

