/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.workflow.NexusServiceOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WorkflowImplementationOptions {
    private static final WorkflowImplementationOptions DEFAULT_INSTANCE = WorkflowImplementationOptions.newBuilder().build();
    private final Class<? extends Throwable>[] failWorkflowExceptionTypes;
    @Nullable
    private final Map<String, ActivityOptions> activityOptions;
    private final ActivityOptions defaultActivityOptions;
    @Nullable
    private final Map<String, LocalActivityOptions> localActivityOptions;
    private final LocalActivityOptions defaultLocalActivityOptions;
    @Nullable
    private final Map<String, NexusServiceOptions> nexusServiceOptions;
    private final NexusServiceOptions defaultNexusServiceOptions;

    public static WorkflowImplementationOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowImplementationOptions options) {
        return new Builder(options);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public WorkflowImplementationOptions(Class<? extends Throwable>[] failWorkflowExceptionTypes, @Nullable Map<String, ActivityOptions> activityOptions, ActivityOptions defaultActivityOptions, @Nullable Map<String, LocalActivityOptions> localActivityOptions, LocalActivityOptions defaultLocalActivityOptions, @Nullable Map<String, NexusServiceOptions> nexusServiceOptions, NexusServiceOptions defaultNexusServiceOptions) {
        this.failWorkflowExceptionTypes = failWorkflowExceptionTypes;
        this.activityOptions = activityOptions;
        this.defaultActivityOptions = defaultActivityOptions;
        this.localActivityOptions = localActivityOptions;
        this.defaultLocalActivityOptions = defaultLocalActivityOptions;
        this.nexusServiceOptions = nexusServiceOptions;
        this.defaultNexusServiceOptions = defaultNexusServiceOptions;
    }

    public Class<? extends Throwable>[] getFailWorkflowExceptionTypes() {
        return this.failWorkflowExceptionTypes;
    }

    @Nonnull
    public Map<String, ActivityOptions> getActivityOptions() {
        return this.activityOptions != null ? Collections.unmodifiableMap(this.activityOptions) : Collections.emptyMap();
    }

    public ActivityOptions getDefaultActivityOptions() {
        return this.defaultActivityOptions;
    }

    @Nonnull
    public Map<String, LocalActivityOptions> getLocalActivityOptions() {
        return this.localActivityOptions != null ? Collections.unmodifiableMap(this.localActivityOptions) : Collections.emptyMap();
    }

    public LocalActivityOptions getDefaultLocalActivityOptions() {
        return this.defaultLocalActivityOptions;
    }

    @Nonnull
    public Map<String, NexusServiceOptions> getNexusServiceOptions() {
        return this.nexusServiceOptions != null ? Collections.unmodifiableMap(this.nexusServiceOptions) : Collections.emptyMap();
    }

    public NexusServiceOptions getDefaultNexusServiceOptions() {
        return this.defaultNexusServiceOptions;
    }

    public String toString() {
        return "WorkflowImplementationOptions{failWorkflowExceptionTypes=" + Arrays.toString(this.failWorkflowExceptionTypes) + ", activityOptions=" + this.activityOptions + ", defaultActivityOptions=" + this.defaultActivityOptions + ", localActivityOptions=" + this.localActivityOptions + ", defaultLocalActivityOptions=" + this.defaultLocalActivityOptions + ", nexusServiceOptions=" + this.nexusServiceOptions + ", defaultNexusServiceOptions=" + this.defaultNexusServiceOptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowImplementationOptions that = (WorkflowImplementationOptions)o;
        return Arrays.equals(this.failWorkflowExceptionTypes, that.failWorkflowExceptionTypes) && Objects.equals(this.activityOptions, that.activityOptions) && Objects.equals(this.defaultActivityOptions, that.defaultActivityOptions) && Objects.equals(this.localActivityOptions, that.localActivityOptions) && Objects.equals(this.defaultLocalActivityOptions, that.defaultLocalActivityOptions) && Objects.equals(this.nexusServiceOptions, that.nexusServiceOptions) && Objects.equals(this.defaultNexusServiceOptions, that.defaultNexusServiceOptions);
    }

    public int hashCode() {
        int result = Objects.hash(this.activityOptions, this.defaultActivityOptions, this.localActivityOptions, this.defaultLocalActivityOptions, this.nexusServiceOptions, this.defaultNexusServiceOptions);
        result = 31 * result + Arrays.hashCode(this.failWorkflowExceptionTypes);
        return result;
    }

    public static final class Builder {
        private Class<? extends Throwable>[] failWorkflowExceptionTypes;
        private Map<String, ActivityOptions> activityOptions;
        private ActivityOptions defaultActivityOptions;
        private Map<String, LocalActivityOptions> localActivityOptions;
        private LocalActivityOptions defaultLocalActivityOptions;
        private Map<String, NexusServiceOptions> nexusServiceOptions;
        private NexusServiceOptions defaultNexusServiceOptions;

        private Builder() {
        }

        private Builder(WorkflowImplementationOptions options) {
            if (options == null) {
                return;
            }
            this.failWorkflowExceptionTypes = options.getFailWorkflowExceptionTypes();
            this.activityOptions = options.getActivityOptions();
            this.defaultActivityOptions = options.getDefaultActivityOptions();
            this.localActivityOptions = options.getLocalActivityOptions();
            this.defaultLocalActivityOptions = options.getDefaultLocalActivityOptions();
            this.nexusServiceOptions = options.getNexusServiceOptions();
            this.defaultNexusServiceOptions = options.getDefaultNexusServiceOptions();
        }

        @SafeVarargs
        public final Builder setFailWorkflowExceptionTypes(Class<? extends Throwable> ... failWorkflowExceptionTypes) {
            this.failWorkflowExceptionTypes = failWorkflowExceptionTypes;
            return this;
        }

        public Builder setActivityOptions(Map<String, ActivityOptions> activityOptions) {
            this.activityOptions = new HashMap<String, ActivityOptions>(Objects.requireNonNull(activityOptions));
            return this;
        }

        public Builder setDefaultActivityOptions(ActivityOptions defaultActivityOptions) {
            this.defaultActivityOptions = Objects.requireNonNull(defaultActivityOptions);
            return this;
        }

        public Builder setLocalActivityOptions(Map<String, LocalActivityOptions> localActivityOptions) {
            this.localActivityOptions = new HashMap<String, LocalActivityOptions>(Objects.requireNonNull(localActivityOptions));
            return this;
        }

        public Builder setDefaultLocalActivityOptions(LocalActivityOptions defaultLocalActivityOptions) {
            this.defaultLocalActivityOptions = Objects.requireNonNull(defaultLocalActivityOptions);
            return this;
        }

        public Builder setNexusServiceOptions(Map<String, NexusServiceOptions> nexusServiceOptions) {
            this.nexusServiceOptions = new HashMap<String, NexusServiceOptions>(Objects.requireNonNull(nexusServiceOptions));
            return this;
        }

        public Builder setDefaultNexusServiceOptions(NexusServiceOptions defaultNexusServiceOptions) {
            this.defaultNexusServiceOptions = Objects.requireNonNull(defaultNexusServiceOptions);
            return this;
        }

        public WorkflowImplementationOptions build() {
            return new WorkflowImplementationOptions(this.failWorkflowExceptionTypes == null ? new Class[]{} : this.failWorkflowExceptionTypes, this.activityOptions == null ? null : this.activityOptions, this.defaultActivityOptions, this.localActivityOptions == null ? null : this.localActivityOptions, this.defaultLocalActivityOptions, this.nexusServiceOptions == null ? null : this.nexusServiceOptions, this.defaultNexusServiceOptions);
        }
    }
}

