/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Strings;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.errordetails.v1.QueryFailedFailure;
import io.temporal.api.errordetails.v1.WorkflowExecutionAlreadyStartedFailure;
import io.temporal.api.errordetails.v1.WorkflowNotReadyFailure;
import io.temporal.api.update.v1.WaitPolicy;
import io.temporal.client.UpdateOptions;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowException;
import io.temporal.client.WorkflowExecutionAlreadyStarted;
import io.temporal.client.WorkflowExecutionDescription;
import io.temporal.client.WorkflowNotFoundException;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowQueryConditionallyRejectedException;
import io.temporal.client.WorkflowQueryException;
import io.temporal.client.WorkflowQueryRejectedException;
import io.temporal.client.WorkflowServiceException;
import io.temporal.client.WorkflowStub;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.client.WorkflowUpdateStage;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.client.LazyWorkflowUpdateHandleImpl;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.serviceclient.StatusUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class WorkflowStubImpl
implements WorkflowStub {
    private final WorkflowClientOptions clientOptions;
    private final WorkflowClientCallsInterceptor workflowClientInvoker;
    private final Optional<String> workflowType;
    private final AtomicReference<WorkflowExecution> execution = new AtomicReference();
    private final AtomicReference<WorkflowExecution> startedExecution = new AtomicReference();
    @Nullable
    private final WorkflowOptions options;

    WorkflowStubImpl(WorkflowClientOptions clientOptions, WorkflowClientCallsInterceptor workflowClientInvoker, Optional<String> workflowType, WorkflowExecution execution) {
        this.clientOptions = clientOptions;
        this.workflowClientInvoker = workflowClientInvoker;
        this.workflowType = workflowType;
        if (execution == null || execution.getWorkflowId().isEmpty()) {
            throw new IllegalArgumentException("null or empty workflowId");
        }
        this.execution.set(execution);
        this.options = null;
    }

    WorkflowStubImpl(WorkflowClientOptions clientOptions, WorkflowClientCallsInterceptor workflowClientInvoker, String workflowType, @Nonnull WorkflowOptions options) {
        this.clientOptions = clientOptions;
        this.workflowClientInvoker = workflowClientInvoker;
        this.workflowType = Optional.of(workflowType);
        this.options = options;
    }

    @Override
    public void signal(String signalName, Object ... args) {
        this.checkStarted();
        WorkflowExecution targetExecution = this.currentExecutionWithoutRunId();
        try {
            this.workflowClientInvoker.signal(new WorkflowClientCallsInterceptor.WorkflowSignalInput(targetExecution, signalName, Header.empty(), args));
        }
        catch (Exception e) {
            Throwable throwable = this.throwAsWorkflowFailureException(e, targetExecution);
            throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), throwable);
        }
    }

    private WorkflowExecution startWithOptions(WorkflowOptions options, Object ... args) {
        this.checkExecutionIsNotStarted();
        String workflowId = WorkflowStubImpl.getWorkflowIdForStart(options);
        WorkflowExecution workflowExecution = null;
        try {
            WorkflowClientCallsInterceptor.WorkflowStartOutput workflowStartOutput = this.workflowClientInvoker.start(new WorkflowClientCallsInterceptor.WorkflowStartInput(workflowId, this.workflowType.get(), Header.empty(), args, options));
            workflowExecution = workflowStartOutput.getWorkflowExecution();
            this.populateExecutionAfterStart(workflowExecution);
            return workflowExecution;
        }
        catch (StatusRuntimeException e) {
            throw this.wrapStartException(workflowId, this.workflowType.orElse(null), e);
        }
        catch (Exception e) {
            if (workflowExecution == null) {
                workflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).build();
            }
            throw new WorkflowServiceException(workflowExecution, this.workflowType.orElse(null), e);
        }
    }

    @Override
    public WorkflowExecution start(Object ... args) {
        if (this.options == null) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        return this.startWithOptions(WorkflowOptions.merge(null, null, this.options), args);
    }

    @Override
    public <R> WorkflowUpdateHandle<R> startUpdateWithStart(UpdateOptions<R> updateOptions, Object[] updateArgs, Object[] startArgs) {
        if (this.options == null) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing in WorkflowStub");
        }
        if (this.options.getWorkflowIdConflictPolicy() == null) {
            throw new IllegalStateException("WorkflowIdConflictPolicy is required in WorkflowOptions for Update-With-Start");
        }
        updateOptions.validate();
        String workflowId = WorkflowStubImpl.getWorkflowIdForStart(this.options);
        WorkflowExecution workflowExecution = null;
        try {
            WorkflowClientCallsInterceptor.WorkflowStartInput startInput = new WorkflowClientCallsInterceptor.WorkflowStartInput(workflowId, this.workflowType.get(), Header.empty(), startArgs, this.options);
            WorkflowClientCallsInterceptor.StartUpdateInput<R> updateInput = this.startUpdateInput(updateOptions, updateArgs, WorkflowExecution.newBuilder().setWorkflowId(workflowId).build());
            WorkflowClientCallsInterceptor.WorkflowUpdateWithStartInput<R> input = new WorkflowClientCallsInterceptor.WorkflowUpdateWithStartInput<R>(startInput, updateInput);
            WorkflowClientCallsInterceptor.WorkflowUpdateWithStartOutput<R> output = this.workflowClientInvoker.updateWithStart(input);
            workflowExecution = output.getWorkflowStartOutput().getWorkflowExecution();
            this.populateExecutionAfterStart(workflowExecution);
            return output.getUpdateHandle();
        }
        catch (StatusRuntimeException e) {
            throw this.wrapStartException(workflowId, this.workflowType.orElse(null), e);
        }
        catch (Exception e) {
            if (workflowExecution == null) {
                workflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).build();
            }
            throw new WorkflowServiceException(workflowExecution, this.workflowType.orElse(null), e);
        }
    }

    @Override
    public <R> R executeUpdateWithStart(UpdateOptions<R> updateOptions, Object[] updateArgs, Object[] startArgs) {
        updateOptions.validateWaitForCompleted();
        UpdateOptions optionsWithWaitStageCompleted = updateOptions.toBuilder().setWaitForStage(WorkflowUpdateStage.COMPLETED).build();
        return (R)this.startUpdateWithStart(optionsWithWaitStageCompleted, updateArgs, startArgs).getResult();
    }

    private WorkflowExecution signalWithStartWithOptions(WorkflowOptions options, String signalName, Object[] signalArgs, Object[] startArgs) {
        this.checkExecutionIsNotStarted();
        String workflowId = WorkflowStubImpl.getWorkflowIdForStart(options);
        WorkflowExecution workflowExecution = null;
        try {
            WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput workflowStartOutput = this.workflowClientInvoker.signalWithStart(new WorkflowClientCallsInterceptor.WorkflowSignalWithStartInput(new WorkflowClientCallsInterceptor.WorkflowStartInput(workflowId, this.workflowType.get(), Header.empty(), startArgs, options), signalName, signalArgs));
            workflowExecution = workflowStartOutput.getWorkflowStartOutput().getWorkflowExecution();
            this.populateExecutionAfterStart(workflowExecution);
            return workflowExecution;
        }
        catch (StatusRuntimeException e) {
            throw this.wrapStartException(workflowId, this.workflowType.orElse(null), e);
        }
        catch (Exception e) {
            if (workflowExecution == null) {
                workflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).build();
            }
            throw new WorkflowServiceException(workflowExecution, this.workflowType.orElse(null), e);
        }
    }

    private static String getWorkflowIdForStart(WorkflowOptions options) {
        String workflowId = options.getWorkflowId();
        if (workflowId == null) {
            workflowId = UUID.randomUUID().toString();
        }
        return workflowId;
    }

    @Override
    public WorkflowExecution signalWithStart(String signalName, Object[] signalArgs, Object[] startArgs) {
        if (this.options == null) {
            throw new IllegalStateException("Required parameter WorkflowOptions is missing");
        }
        return this.signalWithStartWithOptions(WorkflowOptions.merge(null, null, this.options), signalName, signalArgs, startArgs);
    }

    @Override
    public Optional<String> getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.options != null ? this.startedExecution.get() : this.execution.get();
    }

    @Override
    public <R> R getResult(Class<R> resultClass) {
        return this.getResult(resultClass, resultClass);
    }

    @Override
    public <R> R getResult(Class<R> resultClass, Type resultType) {
        try {
            return this.getResult(Integer.MAX_VALUE, TimeUnit.MILLISECONDS, resultClass, resultType);
        }
        catch (TimeoutException e) {
            throw new WorkflowServiceException(this.execution.get(), this.workflowType.orElse(null), e);
        }
    }

    @Override
    public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass) throws TimeoutException {
        return this.getResult(timeout, unit, resultClass, resultClass);
    }

    @Override
    public <R> R getResult(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) throws TimeoutException {
        this.checkStarted();
        WorkflowExecution targetExecution = this.execution.get();
        try {
            WorkflowClientCallsInterceptor.GetResultOutput<R> result = this.workflowClientInvoker.getResult(new WorkflowClientCallsInterceptor.GetResultInput<R>(targetExecution, this.workflowType, timeout, unit, resultClass, resultType));
            return result.getResult();
        }
        catch (Exception e) {
            return this.throwAsWorkflowFailureExceptionForResult(e, resultClass, targetExecution);
        }
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass) {
        return this.getResultAsync(resultClass, resultClass);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(Class<R> resultClass, Type resultType) {
        return this.getResultAsync(Long.MAX_VALUE, TimeUnit.MILLISECONDS, resultClass, resultType);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass) {
        return this.getResultAsync(timeout, unit, resultClass, resultClass);
    }

    @Override
    public <R> CompletableFuture<R> getResultAsync(long timeout, TimeUnit unit, Class<R> resultClass, Type resultType) {
        this.checkStarted();
        WorkflowExecution targetExecution = this.execution.get();
        WorkflowClientCallsInterceptor.GetResultAsyncOutput<R> result = this.workflowClientInvoker.getResultAsync(new WorkflowClientCallsInterceptor.GetResultInput<R>(targetExecution, this.workflowType, timeout, unit, resultClass, resultType));
        return result.getResult().exceptionally(e -> {
            try {
                return this.throwAsWorkflowFailureExceptionForResult((Throwable)e, resultClass, targetExecution);
            }
            catch (TimeoutException ex) {
                throw new CompletionException(ex);
            }
        });
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Object ... args) {
        return this.query(queryType, resultClass, resultClass, args);
    }

    @Override
    public <R> R query(String queryType, Class<R> resultClass, Type resultType, Object ... args) {
        WorkflowClientCallsInterceptor.QueryOutput<R> result;
        this.checkStarted();
        WorkflowExecution targetExecution = this.execution.get();
        try {
            result = this.workflowClientInvoker.query(new WorkflowClientCallsInterceptor.QueryInput<R>(targetExecution, queryType, Header.empty(), args, resultClass, resultType));
        }
        catch (Exception e) {
            return this.throwAsWorkflowFailureExceptionForQuery(e, resultClass, targetExecution);
        }
        if (result.isQueryRejected()) {
            throw new WorkflowQueryConditionallyRejectedException(targetExecution, this.workflowType.orElse(null), this.clientOptions.getQueryRejectCondition(), result.getQueryRejectedStatus(), null);
        }
        return result.getResult();
    }

    @Override
    public <R> R update(String updateName, Class<R> resultClass, Object ... args) {
        this.checkStarted();
        try {
            UpdateOptions options = UpdateOptions.newBuilder().setUpdateName(updateName).setWaitForStage(WorkflowUpdateStage.COMPLETED).setResultClass(resultClass).build();
            return (R)this.startUpdate(options, args).getResultAsync().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
    }

    @Override
    public <R> WorkflowUpdateHandle<R> startUpdate(String updateName, WorkflowUpdateStage waitForStage, Class<R> resultClass, Object ... args) {
        UpdateOptions options = UpdateOptions.newBuilder().setUpdateName(updateName).setWaitForStage(waitForStage).setResultClass(resultClass).setResultType(resultClass).build();
        return this.startUpdate(options, args);
    }

    @Override
    public <R> WorkflowUpdateHandle<R> startUpdate(UpdateOptions<R> options, Object ... args) {
        this.checkStarted();
        options.validate();
        WorkflowExecution targetExecution = this.execution.get();
        try {
            WorkflowClientCallsInterceptor.StartUpdateInput<R> input = this.startUpdateInput(options, args, targetExecution);
            return this.workflowClientInvoker.startUpdate(input);
        }
        catch (Exception e) {
            Throwable throwable = this.throwAsWorkflowFailureException(e, targetExecution);
            throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), throwable);
        }
    }

    private <R> WorkflowClientCallsInterceptor.StartUpdateInput<R> startUpdateInput(UpdateOptions<R> options, Object[] args, WorkflowExecution targetExecution) {
        String updateId = Strings.isNullOrEmpty((String)options.getUpdateId()) ? UUID.randomUUID().toString() : options.getUpdateId();
        WorkflowClientCallsInterceptor.StartUpdateInput<R> input = new WorkflowClientCallsInterceptor.StartUpdateInput<R>(targetExecution, this.workflowType, options.getUpdateName(), Header.empty(), updateId, args, options.getResultClass(), options.getResultType(), options.getFirstExecutionRunId(), WaitPolicy.newBuilder().setLifecycleStage(options.getWaitForStage().getProto()).build());
        return input;
    }

    @Override
    public <R> WorkflowUpdateHandle<R> getUpdateHandle(String updateId, Class<R> resultClass) {
        return new LazyWorkflowUpdateHandleImpl<R>(this.workflowClientInvoker, this.workflowType.orElse(null), "", updateId, this.execution.get(), resultClass, resultClass);
    }

    @Override
    public <R> WorkflowUpdateHandle<R> getUpdateHandle(String updateId, Class<R> resultClass, Type resultType) {
        return new LazyWorkflowUpdateHandleImpl<R>(this.workflowClientInvoker, this.workflowType.orElse(null), "", updateId, this.execution.get(), resultClass, resultType);
    }

    @Override
    public void cancel() {
        this.checkStarted();
        WorkflowExecution targetExecution = this.currentExecutionWithoutRunId();
        try {
            this.workflowClientInvoker.cancel(new WorkflowClientCallsInterceptor.CancelInput(targetExecution));
        }
        catch (Exception e) {
            Throwable failure = this.throwAsWorkflowFailureException(e, targetExecution);
            throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), failure);
        }
    }

    @Override
    public void terminate(@Nullable String reason, Object ... details) {
        this.checkStarted();
        WorkflowExecution targetExecution = this.currentExecutionWithoutRunId();
        try {
            this.workflowClientInvoker.terminate(new WorkflowClientCallsInterceptor.TerminateInput(targetExecution, reason, details));
        }
        catch (Exception e) {
            Throwable failure = this.throwAsWorkflowFailureException(e, targetExecution);
            throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), failure);
        }
    }

    @Override
    public WorkflowExecutionDescription describe() {
        this.checkStarted();
        WorkflowExecution targetExecution = this.execution.get();
        try {
            WorkflowClientCallsInterceptor.DescribeWorkflowOutput result = this.workflowClientInvoker.describe(new WorkflowClientCallsInterceptor.DescribeWorkflowInput(targetExecution));
            return result.getDescription();
        }
        catch (Exception e) {
            Throwable failure = this.throwAsWorkflowFailureException(e, targetExecution);
            throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), failure);
        }
    }

    @Override
    public Optional<WorkflowOptions> getOptions() {
        return Optional.ofNullable(this.options);
    }

    @Override
    public WorkflowStub newInstance(WorkflowOptions options) {
        return new WorkflowStubImpl(this.clientOptions, this.workflowClientInvoker, this.workflowType.orElse(null), options);
    }

    private void checkStarted() {
        if (this.execution.get() == null) {
            throw new IllegalStateException("Null workflowId. Was workflow started?");
        }
    }

    private void checkExecutionIsNotStarted() {
        if (this.execution.get() != null) {
            throw new IllegalStateException("Cannot reuse a stub instance to start more than one workflow execution. The stub points to already started execution. If you are trying to wait for a workflow completion either change WorkflowIdReusePolicy from AllowDuplicate or use WorkflowStub.getResult");
        }
    }

    private RuntimeException wrapStartException(String workflowId, String workflowType, StatusRuntimeException e) {
        WorkflowExecution.Builder executionBuilder = WorkflowExecution.newBuilder().setWorkflowId(workflowId);
        WorkflowExecutionAlreadyStartedFailure f = (WorkflowExecutionAlreadyStartedFailure)StatusUtils.getFailure((StatusRuntimeException)e, WorkflowExecutionAlreadyStartedFailure.class);
        if (f != null) {
            WorkflowExecution exe = executionBuilder.setRunId(f.getRunId()).build();
            this.populateExecutionAfterStart(exe);
            return new WorkflowExecutionAlreadyStarted(exe, workflowType, e);
        }
        WorkflowExecution exe = executionBuilder.build();
        return new WorkflowServiceException(exe, workflowType, e);
    }

    private WorkflowExecution currentExecutionWithoutRunId() {
        WorkflowExecution workflowExecution = this.execution.get();
        if (Strings.isNullOrEmpty((String)workflowExecution.getRunId())) {
            return workflowExecution;
        }
        return WorkflowExecution.newBuilder((WorkflowExecution)workflowExecution).setRunId("").build();
    }

    private <R> R throwAsWorkflowFailureExceptionForQuery(Throwable failure, Class<R> returnType, WorkflowExecution targetExecution) {
        if ((failure = this.throwAsWorkflowFailureException(failure, targetExecution)) instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)failure;
            if (StatusUtils.hasFailure((StatusRuntimeException)sre, QueryFailedFailure.class)) {
                throw new WorkflowQueryException(this.execution.get(), this.workflowType.orElse(null), failure);
            }
            if (Status.Code.FAILED_PRECONDITION.equals((Object)sre.getStatus().getCode()) && StatusUtils.hasFailure((StatusRuntimeException)sre, WorkflowNotReadyFailure.class)) {
                throw new WorkflowQueryRejectedException(targetExecution, this.workflowType.orElse(null), failure);
            }
        }
        throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), failure);
    }

    private <R> R throwAsWorkflowFailureExceptionForResult(Throwable failure, Class<R> returnType, WorkflowExecution targetExecution) throws TimeoutException {
        if ((failure = this.throwAsWorkflowFailureException(failure, targetExecution)) instanceof TimeoutException) {
            throw (TimeoutException)failure;
        }
        if (failure instanceof CanceledFailure) {
            throw (CanceledFailure)failure;
        }
        throw new WorkflowServiceException(targetExecution, this.workflowType.orElse(null), failure);
    }

    private Throwable throwAsWorkflowFailureException(Throwable failure, WorkflowExecution targetExecution) {
        if (failure instanceof CompletionException) {
            failure = failure.getCause();
        }
        if ((failure = CheckedExceptionWrapper.unwrap((Throwable)failure)) instanceof Error) {
            throw (Error)failure;
        }
        if (failure instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)failure;
            if (Status.Code.NOT_FOUND.equals((Object)sre.getStatus().getCode())) {
                throw new WorkflowNotFoundException(targetExecution, this.workflowType.orElse(null), sre);
            }
        } else if (failure instanceof WorkflowException) {
            throw (WorkflowException)failure;
        }
        return failure;
    }

    private void populateExecutionAfterStart(WorkflowExecution startedExecution) {
        this.startedExecution.set(startedExecution);
        this.execution.set(WorkflowExecution.newBuilder((WorkflowExecution)startedExecution).setRunId("").build());
    }
}

