/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.client.schedules.ScheduleRange;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ScheduleCalendarSpec {
    public static final List<ScheduleRange> BEGINNING = Collections.singletonList(new ScheduleRange(0));
    public static final List<ScheduleRange> ALL_MONTH_DAYS = Collections.singletonList(new ScheduleRange(1, 31));
    public static final List<ScheduleRange> ALL_MONTHS = Collections.singletonList(new ScheduleRange(1, 12));
    public static final List<ScheduleRange> ALL_WEEK_DAYS = Collections.singletonList(new ScheduleRange(0, 6));
    private final List<ScheduleRange> seconds;
    private final List<ScheduleRange> minutes;
    private final List<ScheduleRange> hour;
    private final List<ScheduleRange> dayOfMonth;
    private final List<ScheduleRange> month;
    private final List<ScheduleRange> year;
    private final List<ScheduleRange> dayOfWeek;
    private final String comment;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ScheduleCalendarSpec spec) {
        return new Builder(spec);
    }

    private ScheduleCalendarSpec(List<ScheduleRange> seconds, List<ScheduleRange> minutes, List<ScheduleRange> hour, List<ScheduleRange> dayOfMonth, List<ScheduleRange> month, List<ScheduleRange> year, List<ScheduleRange> dayOfWeek, String comment) {
        this.seconds = seconds;
        this.minutes = minutes;
        this.hour = hour;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.year = year;
        this.dayOfWeek = dayOfWeek;
        this.comment = comment;
    }

    public List<ScheduleRange> getSeconds() {
        return this.seconds;
    }

    public List<ScheduleRange> getMinutes() {
        return this.minutes;
    }

    public List<ScheduleRange> getHour() {
        return this.hour;
    }

    public List<ScheduleRange> getDayOfMonth() {
        return this.dayOfMonth;
    }

    public List<ScheduleRange> getMonth() {
        return this.month;
    }

    public List<ScheduleRange> getYear() {
        return this.year;
    }

    public List<ScheduleRange> getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleCalendarSpec that = (ScheduleCalendarSpec)o;
        return Objects.equals(this.seconds, that.seconds) && Objects.equals(this.minutes, that.minutes) && Objects.equals(this.hour, that.hour) && Objects.equals(this.dayOfMonth, that.dayOfMonth) && Objects.equals(this.month, that.month) && Objects.equals(this.year, that.year) && Objects.equals(this.dayOfWeek, that.dayOfWeek) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.seconds, this.minutes, this.hour, this.dayOfMonth, this.month, this.year, this.dayOfWeek, this.comment);
    }

    public String toString() {
        return "ScheduleCalendarSpec{seconds=" + this.seconds + ", minutes=" + this.minutes + ", hour=" + this.hour + ", dayOfMonth=" + this.dayOfMonth + ", month=" + this.month + ", year=" + this.year + ", dayOfWeek=" + this.dayOfWeek + ", comment='" + this.comment + '\'' + '}';
    }

    public static final class Builder {
        private List<ScheduleRange> seconds;
        private List<ScheduleRange> minutes;
        private List<ScheduleRange> hour;
        private List<ScheduleRange> dayOfMonth;
        private List<ScheduleRange> month;
        private List<ScheduleRange> year;
        private List<ScheduleRange> dayOfWeek;
        private String comment;

        private Builder() {
        }

        private Builder(ScheduleCalendarSpec spec) {
            if (spec == null) {
                return;
            }
            this.seconds = spec.seconds;
            this.minutes = spec.minutes;
            this.hour = spec.hour;
            this.dayOfMonth = spec.dayOfMonth;
            this.month = spec.month;
            this.year = spec.year;
            this.dayOfWeek = spec.dayOfWeek;
            this.comment = spec.comment;
        }

        public Builder setSeconds(List<ScheduleRange> seconds) {
            this.seconds = seconds;
            return this;
        }

        public Builder setMinutes(List<ScheduleRange> minutes) {
            this.minutes = minutes;
            return this;
        }

        public Builder setHour(List<ScheduleRange> hour) {
            this.hour = hour;
            return this;
        }

        public Builder setDayOfMonth(List<ScheduleRange> dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public Builder setMonth(List<ScheduleRange> month) {
            this.month = month;
            return this;
        }

        public Builder setYear(List<ScheduleRange> year) {
            this.year = year;
            return this;
        }

        public Builder setDayOfWeek(List<ScheduleRange> dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ScheduleCalendarSpec build() {
            return new ScheduleCalendarSpec(this.seconds == null ? BEGINNING : this.seconds, this.minutes == null ? BEGINNING : this.minutes, this.hour == null ? BEGINNING : this.hour, this.dayOfMonth == null ? ALL_MONTH_DAYS : this.dayOfMonth, this.month == null ? ALL_MONTHS : this.month, this.year == null ? Collections.EMPTY_LIST : this.year, this.dayOfWeek == null ? ALL_WEEK_DAYS : this.dayOfWeek, this.comment == null ? "" : this.comment);
        }
    }
}

