/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import io.grpc.Deadline;
import io.temporal.api.command.v1.Command;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.QueryResultType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.protocol.v1.Message;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.query.v1.WorkflowQueryResult;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.common.UpdateMessage;
import io.temporal.internal.replay.QueryResult;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContextImpl;
import io.temporal.internal.replay.ReplayWorkflowExecutor;
import io.temporal.internal.replay.WorkflowHistoryIterator;
import io.temporal.internal.replay.WorkflowRunTaskHandler;
import io.temporal.internal.replay.WorkflowTaskResult;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.StatesMachinesCallback;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.internal.worker.LocalActivityDispatcher;
import io.temporal.internal.worker.LocalActivityResult;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ReplayWorkflowRunTaskHandler
implements WorkflowRunTaskHandler {
    private final Scope metricsScope;
    private final WorkflowExecutionStartedEventAttributes startedEvent;
    private final Lock lock = new ReentrantLock();
    private final Functions.Proc1<LocalActivityResult> localActivityCompletionSink;
    private final BlockingQueue<LocalActivityResult> localActivityCompletionQueue = new LinkedBlockingDeque<LocalActivityResult>();
    private final LocalActivityDispatcher localActivityDispatcher;
    private final LocalActivityMeteringHelper localActivityMeteringHelper;
    private final ReplayWorkflow workflow;
    private final WorkflowStateMachines workflowStateMachines;
    private int localActivityTaskCount;
    private final ReplayWorkflowContextImpl context;
    private final ReplayWorkflowExecutor replayWorkflowExecutor;
    private final GetSystemInfoResponse.Capabilities capabilities;

    ReplayWorkflowRunTaskHandler(String namespace, ReplayWorkflow workflow, PollWorkflowTaskQueueResponseOrBuilder workflowTask, SingleWorkerOptions workerOptions, Scope metricsScope, LocalActivityDispatcher localActivityDispatcher, GetSystemInfoResponse.Capabilities capabilities) {
        HistoryEvent startedEvent = workflowTask.getHistory().getEvents(0);
        if (!startedEvent.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalArgumentException("First event in the history is not WorkflowExecutionStarted");
        }
        this.startedEvent = startedEvent.getWorkflowExecutionStartedEventAttributes();
        this.metricsScope = metricsScope;
        this.localActivityDispatcher = localActivityDispatcher;
        this.workflow = workflow;
        this.workflowStateMachines = new WorkflowStateMachines((StatesMachinesCallback)new StatesMachinesCallbackImpl(), capabilities);
        String fullReplayDirectQueryType = workflowTask.hasQuery() ? workflowTask.getQuery().getQueryType() : null;
        this.context = new ReplayWorkflowContextImpl(this.workflowStateMachines, namespace, this.startedEvent, workflowTask.getWorkflowExecution(), Timestamps.toMillis((Timestamp)startedEvent.getEventTime()), fullReplayDirectQueryType, workerOptions, metricsScope);
        this.replayWorkflowExecutor = new ReplayWorkflowExecutor(workflow, this.workflowStateMachines, this.context);
        this.localActivityCompletionSink = this.localActivityCompletionQueue::add;
        this.localActivityMeteringHelper = new LocalActivityMeteringHelper();
        this.capabilities = capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTaskResult handleWorkflowTask(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowHistoryIterator historyIterator) throws Throwable {
        this.lock.lock();
        try {
            this.localActivityMeteringHelper.newWFTStarting();
            Deadline wftHearbeatDeadline = Deadline.after((long)((long)((double)Durations.toNanos((Duration)this.startedEvent.getWorkflowTaskTimeout()) * 0.8)), (TimeUnit)TimeUnit.NANOSECONDS);
            if (workflowTask.getPreviousStartedEventId() < this.workflowStateMachines.getLastWFTStartedEventId()) {
                throw new IllegalStateException("Server history for the workflow is below the progress of the workflow on the worker, the progress needs to be discarded");
            }
            this.handleWorkflowTaskImpl(workflowTask, historyIterator);
            this.processLocalActivityRequests(wftHearbeatDeadline);
            List<Command> commands = this.workflowStateMachines.takeCommands();
            List<Message> messages = this.workflowStateMachines.takeMessages();
            EnumSet<SdkFlag> newFlags = this.workflowStateMachines.takeNewSdkFlags();
            ArrayList<Integer> newSdkFlags = new ArrayList<Integer>(newFlags.size());
            for (SdkFlag flag : newFlags) {
                newSdkFlags.add(flag.getValue());
            }
            if (this.context.isWorkflowMethodCompleted()) {
                this.close();
            }
            if (this.context.getWorkflowTaskFailure() != null) {
                throw this.context.getWorkflowTaskFailure();
            }
            Map<String, WorkflowQueryResult> queryResults = this.executeQueries(workflowTask.getQueriesMap());
            WorkflowTaskResult.Builder result = WorkflowTaskResult.newBuilder().setCommands(commands).setMessages(messages).setQueryResults(queryResults).setFinalCommand(this.context.isWorkflowMethodCompleted()).setForceWorkflowTask(this.localActivityTaskCount > 0 && !this.context.isWorkflowMethodCompleted()).setNonfirstLocalActivityAttempts(this.localActivityMeteringHelper.getNonfirstAttempts()).setSdkFlags(newSdkFlags);
            if (this.workflowStateMachines.sdkNameToWrite() != null) {
                result.setWriteSdkName(this.workflowStateMachines.sdkNameToWrite());
            }
            if (this.workflowStateMachines.sdkVersionToWrite() != null) {
                result.setWriteSdkVersion(this.workflowStateMachines.sdkVersionToWrite());
            }
            WorkflowTaskResult workflowTaskResult = result.build();
            return workflowTaskResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult handleDirectQueryWorkflowTask(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowHistoryIterator historyIterator) throws Throwable {
        WorkflowQuery query = workflowTask.getQuery();
        this.lock.lock();
        try {
            this.handleWorkflowTaskImpl(workflowTask, historyIterator);
            if (this.context.isWorkflowMethodCompleted()) {
                this.close();
            }
            if (this.context.getWorkflowTaskFailure() != null) {
                throw this.context.getWorkflowTaskFailure();
            }
            Optional<Payloads> resultPayloads = this.replayWorkflowExecutor.query(query);
            QueryResult queryResult = new QueryResult(resultPayloads, this.context.isWorkflowMethodCompleted());
            return queryResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetStartedEventId(Long eventId) {
        this.workflowStateMachines.resetStartedEventId(eventId);
    }

    private void handleWorkflowTaskImpl(PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowHistoryIterator historyIterator) {
        this.workflowStateMachines.setWorkflowStartedEventId(workflowTask.getStartedEventId());
        this.workflowStateMachines.setReplaying(workflowTask.getPreviousStartedEventId() > 0L);
        this.workflowStateMachines.setMessages(workflowTask.getMessagesList());
        this.applyServerHistory(workflowTask.getStartedEventId(), historyIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyServerHistory(long lastEventId, WorkflowHistoryIterator historyIterator) {
        java.time.Duration expiration = ProtobufTimeUtils.toJavaDuration(this.startedEvent.getWorkflowTaskTimeout());
        historyIterator.initDeadline(Deadline.after((long)expiration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        boolean timerStopped = false;
        Stopwatch sw = this.metricsScope.timer("temporal_workflow_task_replay_latency").start();
        long currentEventId = 0L;
        try {
            while (historyIterator.hasNext()) {
                HistoryEvent event = (HistoryEvent)historyIterator.next();
                currentEventId = event.getEventId();
                boolean hasNext = historyIterator.hasNext();
                try {
                    this.workflowStateMachines.handleEvent(event, hasNext);
                }
                catch (Throwable e) {
                    Class<? extends Throwable>[] failTypes;
                    WorkflowImplementationOptions implementationOptions = this.workflow.getWorkflowContext().getWorkflowImplementationOptions();
                    for (Class<? extends Throwable> failType : failTypes = implementationOptions.getFailWorkflowExceptionTypes()) {
                        if (!failType.isAssignableFrom(e.getClass())) continue;
                        this.metricsScope.counter("temporal_workflow_failed").inc(1L);
                        throw new WorkflowExecutionException(this.workflow.getWorkflowContext().mapWorkflowExceptionToFailure(e));
                    }
                    if (e instanceof WorkflowExecutionException) {
                        this.metricsScope.counter("temporal_workflow_failed").inc(1L);
                    }
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
                if (timerStopped || this.workflowStateMachines.isReplaying()) continue;
                sw.stop();
                timerStopped = true;
            }
            this.verifyAllEventsProcessed(lastEventId, currentEventId);
        }
        finally {
            if (!timerStopped) {
                sw.stop();
            }
        }
    }

    private void verifyAllEventsProcessed(long lastEventId, long processedEventId) {
        if (lastEventId != Long.MAX_VALUE && lastEventId > 0L && processedEventId < lastEventId) {
            throw new IllegalStateException(String.format("Premature end of stream, expectedLastEventID=%d but no more events after eventID=%d", lastEventId, processedEventId));
        }
    }

    private Map<String, WorkflowQueryResult> executeQueries(Map<String, WorkflowQuery> queries) {
        HashMap<String, WorkflowQueryResult> queryResults = new HashMap<String, WorkflowQueryResult>();
        for (Map.Entry<String, WorkflowQuery> entry : queries.entrySet()) {
            WorkflowQuery query = entry.getValue();
            try {
                Optional<Payloads> queryResult = this.replayWorkflowExecutor.query(query);
                WorkflowQueryResult.Builder result = WorkflowQueryResult.newBuilder().setResultType(QueryResultType.QUERY_RESULT_TYPE_ANSWERED);
                if (queryResult.isPresent()) {
                    result.setAnswer(queryResult.get());
                }
                queryResults.put(entry.getKey(), result.build());
            }
            catch (Exception e) {
                String stackTrace = Throwables.getStackTraceAsString((Throwable)e);
                queryResults.put(entry.getKey(), WorkflowQueryResult.newBuilder().setResultType(QueryResultType.QUERY_RESULT_TYPE_FAILED).setErrorMessage(e + "\n" + stackTrace).build());
            }
        }
        return queryResults;
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.replayWorkflowExecutor.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processLocalActivityRequests(Deadline wftHeartbeatDeadline) throws InterruptedException, Throwable {
        while (!this.context.isWorkflowMethodCompleted()) {
            long maxWaitTimeTillHeartbeatNs;
            LocalActivityResult laCompletion;
            List<ExecuteLocalActivityParameters> laRequests = this.workflowStateMachines.takeLocalActivityRequests();
            this.localActivityTaskCount += laRequests.size();
            for (ExecuteLocalActivityParameters laRequest : laRequests) {
                boolean accepted = this.localActivityDispatcher.dispatch(laRequest, this.localActivityCompletionSink, wftHeartbeatDeadline);
                Preconditions.checkState((boolean)accepted, (Object)"Unable to schedule local activity for execution, no more slots available and local activity task queue is full");
                this.localActivityMeteringHelper.addNewLocalActivity(laRequest);
            }
            if (this.localActivityTaskCount == 0 || (laCompletion = this.localActivityCompletionQueue.poll(maxWaitTimeTillHeartbeatNs = wftHeartbeatDeadline.timeRemaining(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS)) == null) break;
            --this.localActivityTaskCount;
            this.localActivityMeteringHelper.markLocalActivityComplete(laCompletion.getActivityId());
            if (laCompletion.getProcessingError() != null) {
                throw laCompletion.getProcessingError().getThrowable();
            }
            this.workflowStateMachines.handleLocalActivityCompletion(laCompletion);
        }
        Preconditions.checkState((this.workflowStateMachines.takeLocalActivityRequests().isEmpty() || this.context.isWorkflowMethodCompleted() ? 1 : 0) != 0, (Object)"[BUG] Local activities requests from the last event loop were not drained and accounted in the outstanding local activities counter");
    }

    @VisibleForTesting
    WorkflowStateMachines getWorkflowStateMachines() {
        return this.workflowStateMachines;
    }

    @VisibleForTesting
    static class LocalActivityMeteringHelper {
        private final Map<String, AtomicInteger> firstWftActivities = new HashMap<String, AtomicInteger>();
        private final Map<String, AtomicInteger> nonFirstWftActivities = new HashMap<String, AtomicInteger>();
        private final Set<String> completed = new HashSet<String>();

        LocalActivityMeteringHelper() {
        }

        void newWFTStarting() {
            for (String activityId : this.firstWftActivities.keySet()) {
                AtomicInteger attemptCount = this.firstWftActivities.get(activityId);
                attemptCount.set(0);
                this.nonFirstWftActivities.put(activityId, attemptCount);
            }
            this.firstWftActivities.clear();
        }

        void addNewLocalActivity(ExecuteLocalActivityParameters params) {
            AtomicInteger attemptsDuringWFTCounter = new AtomicInteger(0);
            params.setOnNewAttemptCallback(attemptsDuringWFTCounter::incrementAndGet);
            this.firstWftActivities.put(params.getActivityId(), attemptsDuringWFTCounter);
        }

        void markLocalActivityComplete(String activityId) {
            this.completed.add(activityId);
        }

        int getNonfirstAttempts() {
            int result = this.nonFirstWftActivities.values().stream().map(ai -> ai.getAndSet(0)).reduce(0, Integer::sum);
            for (String activityId : this.completed) {
                this.firstWftActivities.remove(activityId);
                this.nonFirstWftActivities.remove(activityId);
            }
            this.completed.clear();
            return result;
        }
    }

    private class StatesMachinesCallbackImpl
    implements StatesMachinesCallback {
        private StatesMachinesCallbackImpl() {
        }

        @Override
        public void start(HistoryEvent startWorkflowEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.start(startWorkflowEvent);
        }

        @Override
        public void eventLoop() {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.eventLoop();
        }

        @Override
        public void signal(HistoryEvent signalEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionSignaled(signalEvent);
        }

        @Override
        public void update(UpdateMessage message) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionUpdated(message);
        }

        @Override
        public void cancel(HistoryEvent cancelEvent) {
            ReplayWorkflowRunTaskHandler.this.replayWorkflowExecutor.handleWorkflowExecutionCancelRequested(cancelEvent);
        }
    }
}

