/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.internal.sync.ExternalWorkflowStubImpl;
import io.temporal.workflow.ExternalWorkflowStub;
import io.temporal.workflow.Functions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class ExternalWorkflowInvocationHandler
implements InvocationHandler {
    private final ExternalWorkflowStub stub;
    private final POJOWorkflowInterfaceMetadata workflowMetadata;

    public ExternalWorkflowInvocationHandler(Class<?> workflowInterface, WorkflowExecution execution, WorkflowOutboundCallsInterceptor workflowOutboundCallsInterceptor, Functions.Proc1<String> assertReadOnly) {
        this.workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterface);
        this.stub = new ExternalWorkflowStubImpl(execution, workflowOutboundCallsInterceptor, assertReadOnly);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return this.proxyToString();
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error("unexpected", e);
        }
        if (method.getName().equals("__getUntypedStub")) {
            return this.stub;
        }
        POJOWorkflowMethodMetadata methodMetadata = this.workflowMetadata.getMethodMetadata(method);
        switch (methodMetadata.getType()) {
            case QUERY: {
                throw new UnsupportedOperationException("Query is not supported from workflow to workflow. Use activity that perform the query instead.");
            }
            case WORKFLOW: {
                throw new IllegalStateException("Cannot start a workflow with an external workflow stub created through Workflow.newExternalWorkflowStub");
            }
            case SIGNAL: {
                this.stub.signal(methodMetadata.getName(), args);
                break;
            }
            case UPDATE: {
                throw new UnsupportedOperationException("Cannot update a workflow with an external workflow stub created through Workflow.newExternalWorkflowStub");
            }
            default: {
                throw new IllegalStateException("unreachable");
            }
        }
        return null;
    }

    private String proxyToString() {
        return "ExternalWorkflowProxy{workflowType='" + this.workflowMetadata.getWorkflowType().orElse("") + '\'' + ", execution=" + this.stub.getExecution() + '}';
    }
}

