/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

class WorkflowThreadScheduler {
    private final Lock runnerLock;
    private final Condition yieldedCondition;
    private final Condition runCondition;
    private boolean yielded;
    private boolean completed;
    private int deadlockDetectionLockCounter;
    private long lastProgressTimestampNs;

    WorkflowThreadScheduler(Lock runnerLock) {
        this.runnerLock = runnerLock;
        this.runCondition = runnerLock.newCondition();
        this.yieldedCondition = runnerLock.newCondition();
    }

    public void madeProgressLocked() {
        this.lastProgressTimestampNs = System.nanoTime();
    }

    public void yieldLocked() throws InterruptedException {
        this.madeProgressLocked();
        this.yielded = true;
        this.yieldedCondition.signal();
        this.runCondition.await();
    }

    public void completeLocked() {
        this.madeProgressLocked();
        this.completed = true;
        this.yieldedCondition.signal();
    }

    public void scheduleLocked() {
        Preconditions.checkState((!this.completed ? 1 : 0) != 0, (Object)"shouldn't schedule completed workflow thread");
        this.yielded = false;
        this.runCondition.signal();
    }

    public void lockDeadlockDetection() {
        this.runnerLock.lock();
        try {
            ++this.deadlockDetectionLockCounter;
        }
        finally {
            this.runnerLock.unlock();
        }
    }

    public void unlockDeadlockDetection() {
        this.runnerLock.lock();
        try {
            int newValue = --this.deadlockDetectionLockCounter;
            Preconditions.checkState((newValue >= 0 ? 1 : 0) != 0, (Object)"Unbalanced lockDeadlockDetection/unlockDeadlockDetection calls");
            if (newValue == 0) {
                this.lastProgressTimestampNs = System.nanoTime();
            }
        }
        finally {
            this.runnerLock.unlock();
        }
    }

    public WaitForYieldResult waitForYieldLocked(long deadlockDetectionTimeout, TimeUnit unit) throws InterruptedException {
        boolean timedOut;
        long deadlockDetectionTimeoutNs = unit.toNanos(deadlockDetectionTimeout);
        Preconditions.checkState((this.deadlockDetectionLockCounter == 0 ? 1 : 0) != 0, (Object)"Unbalanced lockDeadlockDetection/unlockDeadlockDetection calls");
        this.lastProgressTimestampNs = System.nanoTime();
        long sinceLastProgressMadeNs = 0L;
        do {
            boolean bl = timedOut = !this.yieldedCondition.await(deadlockDetectionTimeoutNs - sinceLastProgressMadeNs, TimeUnit.NANOSECONDS);
            if (!this.yielded && !this.completed) continue;
            Preconditions.checkState((this.deadlockDetectionLockCounter == 0 ? 1 : 0) != 0, (Object)"Unbalanced lockDeadlockDetection/unlockDeadlockDetection calls");
            return this.completed ? WaitForYieldResult.COMPLETED : WaitForYieldResult.YIELDED;
        } while (!timedOut || (sinceLastProgressMadeNs = this.deadlockDetectionLockCounter == 0 ? System.nanoTime() - this.lastProgressTimestampNs : 0L) < deadlockDetectionTimeoutNs);
        return WaitForYieldResult.DEADLOCK_DETECTED;
    }

    static enum WaitForYieldResult {
        YIELDED,
        COMPLETED,
        DEADLOCK_DETECTED;

    }
}

