/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import io.temporal.common.context.ContextPropagator;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.NonIdempotentHandle;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.context.ContextThreadLocal;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.Status;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowRejectedExecutionError;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.internal.sync.WorkflowThreadContext;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.sync.WorkflowThreadLocalInternal;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class WorkflowThreadImpl
implements WorkflowThread {
    private static final Logger log = LoggerFactory.getLogger(WorkflowThreadImpl.class);
    private final WorkflowThreadExecutor workflowThreadExecutor;
    private final WorkflowThreadContext context;
    private final WorkflowExecutorCache cache;
    private final SyncWorkflowContext syncWorkflowContext;
    private final DeterministicRunnerImpl runner;
    private final RunnableWrapper task;
    private final int priority;
    private Future<?> taskFuture;
    private final Map<WorkflowThreadLocalInternal<?>, Object> threadLocalMap = new HashMap();

    WorkflowThreadImpl(WorkflowThreadExecutor workflowThreadExecutor, SyncWorkflowContext syncWorkflowContext, DeterministicRunnerImpl runner, @Nonnull String name, int priority, boolean detached, CancellationScopeImpl parentCancellationScope, Runnable runnable, WorkflowExecutorCache cache, List<ContextPropagator> contextPropagators, Map<String, Object> propagatedContexts) {
        this.workflowThreadExecutor = workflowThreadExecutor;
        this.syncWorkflowContext = (SyncWorkflowContext)Preconditions.checkNotNull((Object)syncWorkflowContext);
        this.runner = runner;
        this.context = new WorkflowThreadContext(runner.getLock());
        this.cache = cache;
        this.priority = priority;
        this.task = new RunnableWrapper(this.context, syncWorkflowContext.getReplayContext(), (String)Preconditions.checkNotNull((Object)name, (Object)"Thread name shouldn't be null"), detached, parentCancellationScope, runnable, contextPropagators, propagatedContexts);
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("not used");
    }

    @Override
    public boolean isDetached() {
        return this.task.cancellationScope.isDetached();
    }

    @Override
    public void cancel() {
        this.task.cancellationScope.cancel();
    }

    @Override
    public void cancel(String reason) {
        this.task.cancellationScope.cancel(reason);
    }

    @Override
    public String getCancellationReason() {
        return this.task.cancellationScope.getCancellationReason();
    }

    @Override
    public boolean isCancelRequested() {
        return this.task.cancellationScope.isCancelRequested();
    }

    @Override
    public Promise<String> getCancellationRequest() {
        return this.task.cancellationScope.getCancellationRequest();
    }

    @Override
    public void start() {
        this.context.verifyAndStart();
        while (true) {
            try {
                this.taskFuture = this.workflowThreadExecutor.submit(this.task);
                return;
            }
            catch (RejectedExecutionException e) {
                if (this.cache != null) {
                    SyncWorkflowContext workflowContext;
                    ReplayWorkflowContext context;
                    boolean evicted;
                    if (evicted = this.cache.evictAnyNotInProcessing((context = (workflowContext = this.getWorkflowContext()).getReplayContext()).getWorkflowExecution(), workflowContext.getMetricsScope())) continue;
                    throw new WorkflowRejectedExecutionError(e);
                }
                throw new WorkflowRejectedExecutionError(e);
            }
            break;
        }
    }

    @Override
    public boolean isStarted() {
        return this.context.getStatus() != Status.CREATED;
    }

    @Override
    public WorkflowThreadContext getWorkflowThreadContext() {
        return this.context;
    }

    @Override
    public DeterministicRunnerImpl getRunner() {
        return this.runner;
    }

    @Override
    public SyncWorkflowContext getWorkflowContext() {
        return this.syncWorkflowContext;
    }

    @Override
    public void setName(String name) {
        this.task.setName(name);
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public long getId() {
        return this.hashCode();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean runUntilBlocked(long deadlockDetectionTimeoutMs) {
        if (this.taskFuture == null) {
            this.start();
        }
        return this.context.runUntilBlocked(deadlockDetectionTimeoutMs);
    }

    @Override
    public NonIdempotentHandle lockDeadlockDetector() {
        return this.context.lockDeadlockDetector();
    }

    @Override
    public boolean isDone() {
        return this.context.isDone();
    }

    @Override
    public Throwable getUnhandledException() {
        return this.context.getUnhandledException();
    }

    public void evaluateInCoroutineContext(Functions.Proc1<String> function) {
        this.context.evaluateInCoroutineContext(function);
    }

    @Override
    public Future<?> stopNow() {
        Thread thread = this.context.getCurrentThread();
        if (Thread.currentThread().equals(thread)) {
            throw new Error("Cannot call destroy on itself: " + thread.getName());
        }
        this.context.initiateDestroy();
        if (this.taskFuture == null) {
            return this.getCompletedFuture();
        }
        return this.taskFuture;
    }

    private Future<?> getCompletedFuture() {
        CompletableFuture<String> f = new CompletableFuture<String>();
        f.complete("done");
        return f;
    }

    @Override
    public void addStackTrace(StringBuilder result) {
        result.append(this.getName());
        Thread thread = this.context.getCurrentThread();
        if (thread == null) {
            result.append("(NEW)");
            return;
        }
        result.append(": (BLOCKED on ").append(this.getWorkflowThreadContext().getYieldReason()).append(")\n");
        int omitTop = 5;
        int omitBottom = 7;
        if ("workflow-root".equals(this.getName())) {
            omitBottom = 11;
        } else if (this.getName().startsWith("workflow-method")) {
            omitBottom = 11;
        }
        StackTraceElement[] stackTrace = thread.getStackTrace();
        for (int i = omitTop; i < stackTrace.length - omitBottom; ++i) {
            StackTraceElement e = stackTrace[i];
            if (i == omitTop && "await".equals(e.getMethodName())) continue;
            result.append(e);
            result.append("\n");
        }
    }

    @Override
    public void yield(String reason, Supplier<Boolean> unblockCondition) {
        this.context.yield(reason, unblockCondition);
    }

    @Override
    public void exitThread() {
        this.runner.exit();
        throw new DestroyWorkflowThreadError("exit");
    }

    @Override
    public <T> void setThreadLocal(WorkflowThreadLocalInternal<T> key, T value) {
        this.threadLocalMap.put(key, value);
    }

    @Override
    public <T> Optional<Optional<T>> getThreadLocal(WorkflowThreadLocalInternal<T> key) {
        if (!this.threadLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(Optional.ofNullable(this.threadLocalMap.get(key)));
    }

    @Override
    public String getStackTrace() {
        StackTraceElement[] st = this.task.getStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.append(this.task.getName());
        pw.append("\n");
        for (StackTraceElement se : st) {
            pw.println("\tat " + se);
        }
        return sw.toString();
    }

    static class YieldWithTimeoutCondition
    implements Supplier<Boolean> {
        private final Supplier<Boolean> unblockCondition;
        private final long blockedUntil;
        private boolean timedOut;

        YieldWithTimeoutCondition(Supplier<Boolean> unblockCondition, long blockedUntil) {
            this.unblockCondition = unblockCondition;
            this.blockedUntil = blockedUntil;
        }

        boolean isTimedOut() {
            return this.timedOut;
        }

        @Override
        public Boolean get() {
            boolean result = this.unblockCondition.get();
            if (result) {
                return true;
            }
            long currentTimeMillis = WorkflowInternal.currentTimeMillis();
            this.timedOut = currentTimeMillis >= this.blockedUntil;
            return this.timedOut;
        }
    }

    class RunnableWrapper
    implements Runnable {
        private final WorkflowThreadContext threadContext;
        private final ReplayWorkflowContext replayWorkflowContext;
        private String originalName;
        private String name;
        private final CancellationScopeImpl cancellationScope;
        private final List<ContextPropagator> contextPropagators;
        private final Map<String, Object> propagatedContexts;

        RunnableWrapper(WorkflowThreadContext threadContext, ReplayWorkflowContext replayWorkflowContext, String name, boolean detached, CancellationScopeImpl parent, Runnable runnable, List<ContextPropagator> contextPropagators, Map<String, Object> propagatedContexts) {
            this.threadContext = threadContext;
            this.replayWorkflowContext = replayWorkflowContext;
            this.name = name;
            boolean deterministicCancellationScopeOrder = replayWorkflowContext.checkSdkFlag(SdkFlag.DETERMINISTIC_CANCELLATION_SCOPE_ORDER);
            this.cancellationScope = new CancellationScopeImpl(detached, deterministicCancellationScopeOrder, runnable, parent);
            Preconditions.checkState((WorkflowThreadImpl.this.context.getStatus() == Status.CREATED ? 1 : 0) != 0, (Object)"threadContext not in CREATED state");
            this.contextPropagators = contextPropagators;
            this.propagatedContexts = propagatedContexts;
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            this.originalName = thread.getName();
            thread.setName(this.name);
            this.threadContext.initializeCurrentThread(thread);
            DeterministicRunnerImpl.setCurrentThreadInternal(WorkflowThreadImpl.this);
            MDC.put((String)"WorkflowId", (String)this.replayWorkflowContext.getWorkflowId());
            MDC.put((String)"WorkflowType", (String)this.replayWorkflowContext.getWorkflowType().getName());
            MDC.put((String)"RunId", (String)this.replayWorkflowContext.getRunId());
            MDC.put((String)"TaskQueue", (String)this.replayWorkflowContext.getTaskQueue());
            MDC.put((String)"Namespace", (String)this.replayWorkflowContext.getNamespace());
            ContextThreadLocal.setContextPropagators(this.contextPropagators);
            ContextThreadLocal.propagateContextToCurrentThread(this.propagatedContexts);
            try {
                this.threadContext.initialYield();
                this.cancellationScope.run();
            }
            catch (DestroyWorkflowThreadError e) {
                if (!this.threadContext.isDestroyRequested()) {
                    this.threadContext.setUnhandledException(e);
                }
            }
            catch (Error e) {
                this.threadContext.setUnhandledException(e);
            }
            catch (CanceledFailure e) {
                if (!WorkflowThreadImpl.this.isCancelRequested()) {
                    this.threadContext.setUnhandledException(e);
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Workflow thread \"%s\" run canceled", this.name));
                }
            }
            catch (Throwable e) {
                this.threadContext.setUnhandledException(e);
            }
            finally {
                DeterministicRunnerImpl.setCurrentThreadInternal(null);
                this.threadContext.makeDone();
                thread.setName(this.originalName);
                MDC.clear();
            }
        }

        public String getName() {
            return this.name;
        }

        StackTraceElement[] getStackTrace() {
            Thread thread = this.threadContext.getCurrentThread();
            if (thread != null) {
                return thread.getStackTrace();
            }
            return new StackTraceElement[0];
        }

        public void setName(String name) {
            this.name = name;
            Thread thread = this.threadContext.getCurrentThread();
            if (thread != null) {
                thread.setName(name);
            }
        }
    }
}

