/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.Timestamp;
import com.uber.m3.tally.Scope;
import io.grpc.Context;
import io.temporal.api.common.v1.WorkerVersionCapabilities;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.GrpcUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.AsyncPoller;
import io.temporal.internal.worker.NexusTask;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerVersioningOptions;
import io.temporal.internal.worker.WorkerVersioningProtoUtils;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.PollerTypeMetricsTag;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNexusPollTask
implements AsyncPoller.PollTaskAsync<NexusTask> {
    private static final Logger log = LoggerFactory.getLogger(AsyncNexusPollTask.class);
    private final TrackingSlotSupplier<?> slotSupplier;
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;
    private final PollNexusTaskQueueRequest pollRequest;
    private final AtomicInteger pollGauge = new AtomicInteger();
    private final Context.CancellableContext grpcContext = Context.ROOT.withCancellation();

    public AsyncNexusPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, @Nonnull WorkerVersioningOptions versioningOptions, @Nonnull Scope metricsScope, @Nonnull Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities, TrackingSlotSupplier<?> slotSupplier) {
        this.service = Objects.requireNonNull(service);
        this.metricsScope = Objects.requireNonNull(metricsScope);
        this.slotSupplier = slotSupplier;
        PollNexusTaskQueueRequest.Builder pollRequest = PollNexusTaskQueueRequest.newBuilder().setNamespace(namespace).setIdentity(identity).setTaskQueue(TaskQueue.newBuilder().setName(taskQueue));
        if (versioningOptions.getWorkerDeploymentOptions() != null) {
            pollRequest.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(versioningOptions.getWorkerDeploymentOptions()));
        } else if (serverCapabilities.get().getBuildIdBasedVersioning()) {
            pollRequest.setWorkerVersionCapabilities(WorkerVersionCapabilities.newBuilder().setBuildId(versioningOptions.getBuildId()).setUseVersioning(versioningOptions.isUsingVersioning()).build());
        }
        this.pollRequest = pollRequest.build();
    }

    @Override
    public CompletableFuture<NexusTask> poll(SlotPermit permit) {
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + this.pollRequest);
        }
        MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.NEXUS_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.incrementAndGet());
        CompletableFuture response = null;
        try {
            response = (CompletableFuture)this.grpcContext.call(() -> GrpcUtils.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollNexusTaskQueue(this.pollRequest)));
        }
        catch (Exception e2) {
            MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.NEXUS_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet());
            throw new RuntimeException(e2);
        }
        return ((CompletableFuture)response.thenApply(r -> {
            if (r == null || r.getTaskToken().isEmpty()) {
                this.metricsScope.counter("temporal_nexus_poll_no_task").inc(1L);
                return null;
            }
            Timestamp startedTime = ProtobufTimeUtils.getCurrentProtoTime();
            this.metricsScope.timer("temporal_nexus_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(startedTime, r.getRequest().getScheduledTime()));
            return new NexusTask((PollNexusTaskQueueResponseOrBuilder)r, permit, () -> this.slotSupplier.releaseSlot(SlotReleaseReason.taskComplete(), permit));
        })).whenComplete((r, e) -> MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.NEXUS_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet()));
    }

    @Override
    public void cancel(Throwable cause) {
        this.grpcContext.cancel(cause);
    }

    @Override
    public String getLabel() {
        return "AsyncNexusPollTask";
    }

    public String toString() {
        return "AsyncNexusPollTask{}";
    }
}

