/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.WorkerVersionCapabilities;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.MultiThreadedPoller;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.StickyQueueBalancer;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerVersioningOptions;
import io.temporal.internal.worker.WorkerVersioningProtoUtils;
import io.temporal.internal.worker.WorkflowTask;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.PollerTypeMetricsTag;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplierFuture;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowPollTask
implements MultiThreadedPoller.PollTask<WorkflowTask> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPollTask.class);
    private final TrackingSlotSupplier<WorkflowSlotInfo> slotSupplier;
    private final StickyQueueBalancer stickyQueueBalancer;
    private final Scope metricsScope;
    private final Scope stickyMetricsScope;
    private final WorkflowServiceGrpc.WorkflowServiceBlockingStub serviceStub;
    private final PollWorkflowTaskQueueRequest pollRequest;
    private final PollWorkflowTaskQueueRequest stickyPollRequest;
    private final AtomicInteger normalPollGauge = new AtomicInteger();
    private final AtomicInteger stickyPollGauge = new AtomicInteger();

    public WorkflowPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nullable String stickyTaskQueue, @Nonnull String identity, @Nonnull WorkerVersioningOptions versioningOptions, @Nonnull TrackingSlotSupplier<WorkflowSlotInfo> slotSupplier, @Nonnull StickyQueueBalancer stickyQueueBalancer, @Nonnull Scope workerMetricsScope, @Nonnull Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities) {
        this.slotSupplier = Objects.requireNonNull(slotSupplier);
        this.stickyQueueBalancer = Objects.requireNonNull(stickyQueueBalancer);
        this.metricsScope = Objects.requireNonNull(workerMetricsScope);
        this.stickyMetricsScope = workerMetricsScope.tagged((Map)new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)String.format("%s:%s", taskQueue, "sticky")).build());
        this.serviceStub = (WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)Objects.requireNonNull(service).blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope);
        PollWorkflowTaskQueueRequest.Builder pollRequestBuilder = PollWorkflowTaskQueueRequest.newBuilder().setNamespace(Objects.requireNonNull(namespace)).setIdentity(Objects.requireNonNull(identity));
        if (versioningOptions.getWorkerDeploymentOptions() != null) {
            pollRequestBuilder.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(versioningOptions.getWorkerDeploymentOptions()));
        } else if (serverCapabilities.get().getBuildIdBasedVersioning()) {
            pollRequestBuilder.setWorkerVersionCapabilities(WorkerVersionCapabilities.newBuilder().setBuildId(versioningOptions.getBuildId()).setUseVersioning(versioningOptions.isUsingVersioning()).build());
        } else {
            pollRequestBuilder.setBinaryChecksum(versioningOptions.getBuildId());
        }
        this.pollRequest = pollRequestBuilder.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue).setKind(TaskQueueKind.TASK_QUEUE_KIND_NORMAL).build()).build();
        this.stickyPollRequest = pollRequestBuilder.setTaskQueue(TaskQueue.newBuilder().setName(stickyTaskQueue).setKind(TaskQueueKind.TASK_QUEUE_KIND_STICKY).setNormalName(taskQueue).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowTask poll() {
        SlotSupplierFuture future;
        boolean isSuccessful = false;
        try {
            future = this.slotSupplier.reserveSlot(new SlotReservationData(this.pollRequest.getTaskQueue().getName(), this.pollRequest.getIdentity(), this.pollRequest.getWorkerVersionCapabilities().getBuildId()));
        }
        catch (Exception e) {
            log.warn("Error while trying to reserve a slot for a workflow", e.getCause());
            return null;
        }
        SlotPermit permit = MultiThreadedPoller.getSlotPermitAndHandleInterrupts(future, this.slotSupplier);
        if (permit == null) {
            return null;
        }
        TaskQueueKind taskQueueKind = this.stickyQueueBalancer.makePoll();
        boolean isSticky = TaskQueueKind.TASK_QUEUE_KIND_STICKY.equals((Object)taskQueueKind);
        PollWorkflowTaskQueueRequest request = isSticky ? this.stickyPollRequest : this.pollRequest;
        Scope scope = isSticky ? this.stickyMetricsScope : this.metricsScope;
        log.trace("poll request begin: {}", (Object)request);
        if (isSticky) {
            MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.WORKFLOW_STICKY_TASK).gauge("temporal_num_pollers").update((double)this.stickyPollGauge.incrementAndGet());
        } else {
            MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.WORKFLOW_TASK).gauge("temporal_num_pollers").update((double)this.normalPollGauge.incrementAndGet());
        }
        try {
            PollWorkflowTaskQueueResponse response = this.doPoll(request, scope);
            if (response == null) {
                WorkflowTask workflowTask = null;
                return workflowTask;
            }
            isSuccessful = true;
            this.stickyQueueBalancer.finishPoll(taskQueueKind, response.getBacklogCountHint());
            this.slotSupplier.markSlotUsed(new WorkflowSlotInfo(response, this.pollRequest), permit);
            WorkflowTask workflowTask = new WorkflowTask(response, rr -> this.slotSupplier.releaseSlot((SlotReleaseReason)rr, permit));
            return workflowTask;
        }
        finally {
            if (isSticky) {
                MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.WORKFLOW_STICKY_TASK).gauge("temporal_num_pollers").update((double)this.stickyPollGauge.decrementAndGet());
            } else {
                MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.WORKFLOW_TASK).gauge("temporal_num_pollers").update((double)this.normalPollGauge.decrementAndGet());
            }
            if (!isSuccessful) {
                this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
                this.stickyQueueBalancer.finishPoll(taskQueueKind, 0L);
            }
        }
    }

    @Nullable
    private PollWorkflowTaskQueueResponse doPoll(PollWorkflowTaskQueueRequest request, Scope metricsScope) {
        PollWorkflowTaskQueueResponse response = this.serviceStub.pollWorkflowTaskQueue(request);
        if (log.isTraceEnabled()) {
            log.trace("poll request returned workflow task: taskQueue={}, workflowType={}, workflowExecution={}, startedEventId={}, previousStartedEventId={}{}", new Object[]{request.getTaskQueue().getName(), response.getWorkflowType(), response.getWorkflowExecution(), response.getStartedEventId(), response.getPreviousStartedEventId(), response.hasQuery() ? ", queryType=" + response.getQuery().getQueryType() : ""});
        }
        if (response == null || response.getTaskToken().isEmpty()) {
            metricsScope.counter("temporal_workflow_task_queue_poll_empty").inc(1L);
            return null;
        }
        metricsScope.counter("temporal_workflow_task_queue_poll_succeed").inc(1L);
        metricsScope.timer("temporal_workflow_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(response.getStartedTime(), response.getScheduledTime()));
        return response;
    }
}

