/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.Payload;
import io.temporal.api.workflowservice.v1.CountWorkflowExecutionsResponse;
import io.temporal.internal.common.SearchAttributesUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class WorkflowExecutionCount {
    private final long count;
    private final List<AggregationGroup> groups;

    public WorkflowExecutionCount(@Nonnull CountWorkflowExecutionsResponse response) {
        this.count = response.getCount();
        this.groups = response.getGroupsList().stream().map(g -> new AggregationGroup(g.getGroupValuesList(), g.getCount())).collect(Collectors.toList());
    }

    public long getCount() {
        return this.count;
    }

    public List<AggregationGroup> getGroups() {
        return this.groups;
    }

    public static class AggregationGroup {
        private final List<List<?>> groupValues;
        private final long count;

        AggregationGroup(List<Payload> groupValues, long count) {
            this.groupValues = groupValues.stream().map(SearchAttributesUtil::decode).collect(Collectors.toList());
            this.count = count;
        }

        public List<List<?>> getGroupValues() {
            return this.groupValues;
        }

        public long getCount() {
            return this.count;
        }
    }
}

