/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.api.common.v1.Payload;
import io.temporal.client.schedules.Schedule;
import io.temporal.client.schedules.ScheduleInfo;
import io.temporal.common.SearchAttributes;
import io.temporal.common.converter.DataConverter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ScheduleDescription {
    private final String id;
    private final ScheduleInfo info;
    private final Schedule schedule;
    private final Map<String, List<?>> searchAttributes;
    private final SearchAttributes typedSearchAttributes;
    private final Map<String, Payload> memo;
    private final DataConverter dataConverter;

    public ScheduleDescription(String id, ScheduleInfo info, Schedule schedule, Map<String, List<?>> searchAttributes, SearchAttributes typedSearchAttributes, Map<String, Payload> memo, DataConverter dataConverter) {
        this.id = id;
        this.info = info;
        this.schedule = schedule;
        this.searchAttributes = searchAttributes;
        this.typedSearchAttributes = typedSearchAttributes;
        this.memo = memo;
        this.dataConverter = dataConverter;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public ScheduleInfo getInfo() {
        return this.info;
    }

    @Nonnull
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Nonnull
    public Map<String, List<?>> getSearchAttributes() {
        return this.searchAttributes;
    }

    @Nonnull
    public SearchAttributes getTypedSearchAttributes() {
        return this.typedSearchAttributes;
    }

    @Nullable
    public <T> Object getMemo(String key, Class<T> valueClass) {
        return this.getMemo(key, valueClass, valueClass);
    }

    @Nullable
    public <T> T getMemo(String key, Class<T> valueClass, Type genericType) {
        Payload memoPayload = this.memo.get(key);
        if (memoPayload == null) {
            return null;
        }
        return this.dataConverter.fromPayload(memoPayload, valueClass, genericType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleDescription that = (ScheduleDescription)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.info, that.info) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.searchAttributes, that.searchAttributes) && Objects.equals(this.typedSearchAttributes, that.typedSearchAttributes) && Objects.equals(this.memo, that.memo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.schedule, this.searchAttributes, this.typedSearchAttributes, this.memo);
    }

    public String toString() {
        return "ScheduleDescription{id='" + this.id + '\'' + ", info=" + this.info + ", schedule=" + this.schedule + ", searchAttributes=" + this.searchAttributes + ", typedSearchAttributes=" + this.typedSearchAttributes + ", memo=" + this.memo + '}';
    }
}

