/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import com.google.common.base.Strings;
import io.temporal.activity.ActivityInterface;
import io.temporal.activity.ActivityMethod;
import java.lang.reflect.Method;
import java.util.Objects;

public final class POJOActivityMethodMetadata {
    private final String name;
    private final Method method;
    private final Class<?> interfaceType;

    POJOActivityMethodMetadata(Method method, Class<?> interfaceType, ActivityInterface activityAnnotation) {
        this.method = Objects.requireNonNull(method);
        this.interfaceType = Objects.requireNonNull(interfaceType);
        ActivityMethod activityMethod = method.getAnnotation(ActivityMethod.class);
        this.name = activityMethod != null && !activityMethod.name().isEmpty() ? activityMethod.name() : activityAnnotation.namePrefix() + POJOActivityMethodMetadata.getActivityNameFromMethod(method);
    }

    private static String getActivityNameFromMethod(Method method) {
        String name = method.getName();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public String getActivityTypeName() {
        if (Strings.isNullOrEmpty((String)this.name)) {
            throw new IllegalStateException("Not annotated: " + this.method);
        }
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        POJOActivityMethodMetadata that = (POJOActivityMethodMetadata)o;
        return com.google.common.base.Objects.equal((Object)this.method, (Object)that.method) && com.google.common.base.Objects.equal(this.interfaceType, that.interfaceType);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.method, this.interfaceType});
    }
}

