/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import io.temporal.worker.WorkerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;

public class WorkerFactoryRegistry {
    private final CopyOnWriteArrayList<WorkerFactory> workerFactories = new CopyOnWriteArrayList();

    public Iterable<WorkerFactory> workerFactoriesRandomOrder() {
        int count = this.workerFactories.size();
        if (count > 1) {
            ArrayList<WorkerFactory> result = new ArrayList<WorkerFactory>(this.workerFactories);
            Collections.shuffle(result);
            return result;
        }
        return this.workerFactories;
    }

    public void register(WorkerFactory workerFactory) {
        this.workerFactories.addIfAbsent(workerFactory);
    }

    public void deregister(WorkerFactory workerFactory) {
        this.workerFactories.remove(workerFactory);
    }
}

