/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.WorkflowLock;
import java.time.Duration;

class WorkflowLockImpl
implements WorkflowLock {
    private boolean locked = false;

    WorkflowLockImpl() {
    }

    @Override
    public void lock() {
        WorkflowInternal.await("WorkflowLock.lock", () -> {
            CancellationScope.throwCanceled();
            return !this.locked;
        });
        this.locked = true;
    }

    @Override
    public boolean tryLock() {
        WorkflowInternal.assertNotReadOnly("WorkflowLock.tryLock");
        if (!this.locked) {
            this.locked = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryLock(Duration timeout) {
        boolean unlocked = WorkflowInternal.await(timeout, "WorkflowLock.tryLock", () -> {
            CancellationScope.throwCanceled();
            return !this.locked;
        });
        if (unlocked) {
            this.locked = true;
            return true;
        }
        return false;
    }

    @Override
    public void unlock() {
        WorkflowInternal.assertNotReadOnly("WorkflowLock.unlock");
        Preconditions.checkState((boolean)this.locked, (Object)"WorkflowLock.unlock called when not locked");
        this.locked = false;
    }

    @Override
    public boolean isHeld() {
        return this.locked;
    }
}

