/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Preconditions;
import io.temporal.common.Experimental;
import io.temporal.common.VersioningBehavior;
import io.temporal.common.WorkerDeploymentVersion;
import java.util.Objects;

@Experimental
public class WorkerDeploymentOptions {
    private final boolean useVersioning;
    private final WorkerDeploymentVersion version;
    private final VersioningBehavior defaultVersioningBehavior;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerDeploymentOptions options) {
        return new Builder(options);
    }

    private WorkerDeploymentOptions(boolean useVersioning, WorkerDeploymentVersion version, VersioningBehavior defaultVersioningBehavior) {
        this.useVersioning = useVersioning;
        this.version = version;
        this.defaultVersioningBehavior = defaultVersioningBehavior;
    }

    public boolean isUsingVersioning() {
        return this.useVersioning;
    }

    public WorkerDeploymentVersion getVersion() {
        return this.version;
    }

    public VersioningBehavior getDefaultVersioningBehavior() {
        return this.defaultVersioningBehavior;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerDeploymentOptions that = (WorkerDeploymentOptions)o;
        return this.useVersioning == that.useVersioning && Objects.equals(this.version, that.version) && this.defaultVersioningBehavior == that.defaultVersioningBehavior;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.useVersioning, this.version, this.defaultVersioningBehavior});
    }

    public String toString() {
        return "WorkerDeploymentOptions{useVersioning=" + this.useVersioning + ", version='" + this.version + '\'' + ", defaultVersioningBehavior=" + (Object)((Object)this.defaultVersioningBehavior) + '}';
    }

    public static final class Builder {
        private boolean useVersioning;
        private WorkerDeploymentVersion version;
        private VersioningBehavior defaultVersioningBehavior = VersioningBehavior.UNSPECIFIED;

        private Builder() {
        }

        private Builder(WorkerDeploymentOptions options) {
            this.useVersioning = options.useVersioning;
            this.version = options.version;
            this.defaultVersioningBehavior = options.defaultVersioningBehavior;
        }

        public Builder setUseVersioning(boolean useVersioning) {
            this.useVersioning = useVersioning;
            return this;
        }

        public Builder setVersion(WorkerDeploymentVersion version) {
            this.version = version;
            return this;
        }

        public Builder setDefaultVersioningBehavior(VersioningBehavior defaultVersioningBehavior) {
            this.defaultVersioningBehavior = defaultVersioningBehavior;
            return this;
        }

        public WorkerDeploymentOptions build() {
            Preconditions.checkState((!this.useVersioning || this.version != null ? 1 : 0) != 0, (Object)"If useVersioning is set, setVersion must be called");
            return new WorkerDeploymentOptions(this.useVersioning, this.version, this.defaultVersioningBehavior);
        }
    }
}

