/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import com.google.common.base.Preconditions;
import io.temporal.worker.tuning.SlotInfo;
import io.temporal.worker.tuning.SlotMarkUsedContext;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseContext;
import io.temporal.worker.tuning.SlotReserveContext;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.SlotSupplierFuture;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;

public class FixedSizeSlotSupplier<SI extends SlotInfo>
implements SlotSupplier<SI> {
    private final int numSlots;
    private final AsyncSemaphore executorSlotsSemaphore;

    public FixedSizeSlotSupplier(int numSlots) {
        Preconditions.checkArgument((numSlots > 0 ? 1 : 0) != 0, (Object)"FixedSizeSlotSupplier must have at least one slot");
        this.numSlots = numSlots;
        this.executorSlotsSemaphore = new AsyncSemaphore(numSlots);
    }

    @Override
    public SlotSupplierFuture reserveSlot(SlotReserveContext<SI> ctx) throws Exception {
        CompletableFuture<Void> slotFuture = this.executorSlotsSemaphore.acquire();
        return SlotSupplierFuture.fromCompletableFuture((CompletableFuture<SlotPermit>)slotFuture.thenApply(ignored -> new SlotPermit()), () -> slotFuture.cancel(true));
    }

    @Override
    public Optional<SlotPermit> tryReserveSlot(SlotReserveContext<SI> ctx) {
        boolean gotOne = this.executorSlotsSemaphore.tryAcquire();
        if (gotOne) {
            return Optional.of(new SlotPermit());
        }
        return Optional.empty();
    }

    @Override
    public void markSlotUsed(SlotMarkUsedContext<SI> ctx) {
    }

    @Override
    public void releaseSlot(SlotReleaseContext<SI> ctx) {
        this.executorSlotsSemaphore.release();
    }

    @Override
    public Optional<Integer> getMaximumSlots() {
        return Optional.of(this.numSlots);
    }

    public String toString() {
        return "FixedSizeSlotSupplier{numSlots=" + this.numSlots + '}';
    }

    static class AsyncSemaphore {
        private final ReentrantLock lock = new ReentrantLock();
        private final Queue<CompletableFuture<Void>> waiters = new ArrayDeque<CompletableFuture<Void>>();
        private int permits;

        AsyncSemaphore(int initialPermits) {
            this.permits = initialPermits;
        }

        public CompletableFuture<Void> acquire() {
            this.lock.lock();
            try {
                if (this.permits > 0) {
                    --this.permits;
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                CompletableFuture<Void> waiter = new CompletableFuture<Void>();
                this.waiters.add(waiter);
                CompletableFuture<Void> completableFuture = waiter;
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean tryAcquire() {
            this.lock.lock();
            try {
                if (this.permits > 0) {
                    --this.permits;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void release() {
            this.lock.lock();
            try {
                CompletableFuture<Void> waiter = this.waiters.poll();
                if (waiter != null) {
                    if (!waiter.complete(null) && waiter.isCancelled()) {
                        this.release();
                    }
                } else {
                    ++this.permits;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

