/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common;

import com.google.common.reflect.TypeToken;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.common.SearchAttributeUpdate;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SearchAttributeKey<T>
implements Comparable<SearchAttributeKey<T>> {
    private static final Type KEYWORD_LIST_REFLECT_TYPE = new TypeToken<List<String>>(){}.getType();
    private final String name;
    private final IndexedValueType valueType;
    private final Class<? super T> valueClass;
    private final Type valueReflectType;

    public static SearchAttributeKey<String> forText(String name) {
        return new SearchAttributeKey<String>(name, IndexedValueType.INDEXED_VALUE_TYPE_TEXT, String.class);
    }

    public static SearchAttributeKey<String> forKeyword(String name) {
        return new SearchAttributeKey<String>(name, IndexedValueType.INDEXED_VALUE_TYPE_KEYWORD, String.class);
    }

    public static SearchAttributeKey<Long> forLong(String name) {
        return new SearchAttributeKey<Long>(name, IndexedValueType.INDEXED_VALUE_TYPE_INT, Long.class);
    }

    public static SearchAttributeKey<Double> forDouble(String name) {
        return new SearchAttributeKey<Double>(name, IndexedValueType.INDEXED_VALUE_TYPE_DOUBLE, Double.class);
    }

    public static SearchAttributeKey<Boolean> forBoolean(String name) {
        return new SearchAttributeKey<Boolean>(name, IndexedValueType.INDEXED_VALUE_TYPE_BOOL, Boolean.class);
    }

    public static SearchAttributeKey<OffsetDateTime> forOffsetDateTime(String name) {
        return new SearchAttributeKey<OffsetDateTime>(name, IndexedValueType.INDEXED_VALUE_TYPE_DATETIME, OffsetDateTime.class);
    }

    public static SearchAttributeKey<List<String>> forKeywordList(String name) {
        return new SearchAttributeKey<List<String>>(name, IndexedValueType.INDEXED_VALUE_TYPE_KEYWORD_LIST, List.class, KEYWORD_LIST_REFLECT_TYPE);
    }

    public static SearchAttributeKey<Payload> forUntyped(String name) {
        return new SearchAttributeKey<Payload>(name, IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED, Payload.class);
    }

    private SearchAttributeKey(String name, IndexedValueType valueType, Class<? super T> valueClass) {
        this(name, valueType, valueClass, valueClass);
    }

    private SearchAttributeKey(String name, IndexedValueType valueType, Class<? super T> valueClass, Type valueReflectType) {
        this.name = name;
        this.valueType = valueType;
        this.valueClass = valueClass;
        this.valueReflectType = valueReflectType;
    }

    public String getName() {
        return this.name;
    }

    public IndexedValueType getValueType() {
        return this.valueType;
    }

    public Class<? super T> getValueClass() {
        return this.valueClass;
    }

    public Type getValueReflectType() {
        return this.valueReflectType;
    }

    public SearchAttributeUpdate<T> valueSet(@Nonnull T value) {
        if (this.valueType == IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED) {
            throw new IllegalStateException("untyped keys should not be used in workflows");
        }
        return SearchAttributeUpdate.valueSet(this, value);
    }

    public SearchAttributeUpdate<T> valueUnset() {
        if (this.valueType == IndexedValueType.INDEXED_VALUE_TYPE_UNSPECIFIED) {
            throw new IllegalStateException("untyped keys should not be used in workflows");
        }
        return SearchAttributeUpdate.valueUnset(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchAttributeKey that = (SearchAttributeKey)o;
        return this.name.equals(that.name) && this.valueType == that.valueType && this.valueClass.equals(that.valueClass);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.valueType, this.valueClass);
    }

    @Override
    public int compareTo(SearchAttributeKey<T> o) {
        int c = this.name.compareTo(o.name);
        if (c == 0) {
            c = this.valueType.compareTo((Enum)o.valueType);
        }
        if (c == 0) {
            c = this.valueClass.getName().compareTo(o.valueClass.getName());
        }
        return c;
    }
}

