/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.activity.ActivityInfo;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.client.ActivityCanceledException;
import io.temporal.client.ActivityCompletionException;
import io.temporal.client.ActivityCompletionFailureException;
import io.temporal.client.ActivityNotExistsException;
import io.temporal.client.ActivityPausedException;
import io.temporal.client.ActivityResetException;
import io.temporal.client.ActivityWorkerShutdownException;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.activity.HeartbeatContext;
import io.temporal.internal.client.ActivityClientHelper;
import io.temporal.payload.context.ActivitySerializationContext;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class HeartbeatContextImpl
implements HeartbeatContext {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatContextImpl.class);
    private static final long HEARTBEAT_RETRY_WAIT_MILLIS = 1000L;
    private final Lock lock = new ReentrantLock();
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final ActivityInfo info;
    private final String identity;
    private final ScheduledExecutorService heartbeatExecutor;
    private final long heartbeatIntervalMillis;
    private final DataConverter dataConverter;
    private final DataConverter dataConverterWithActivityContext;
    private final Scope metricsScope;
    private final Optional<Payloads> prevAttemptHeartbeatDetails;
    private boolean receivedAHeartbeat = false;
    private Object lastDetails;
    private boolean hasOutstandingHeartbeat;
    private ScheduledFuture<?> scheduledHeartbeat;
    private ActivityCompletionException lastException;

    public HeartbeatContextImpl(WorkflowServiceStubs service, String namespace, ActivityInfo info, DataConverter dataConverter, ScheduledExecutorService heartbeatExecutor, Scope metricsScope, String identity, Duration maxHeartbeatThrottleInterval, Duration defaultHeartbeatThrottleInterval) {
        this.service = service;
        this.metricsScope = metricsScope;
        this.dataConverter = dataConverter;
        this.dataConverterWithActivityContext = dataConverter.withContext(new ActivitySerializationContext(namespace, info.getWorkflowId(), info.getWorkflowType(), info.getActivityType(), info.getActivityTaskQueue(), info.isLocal()));
        this.namespace = namespace;
        this.info = info;
        this.identity = identity;
        this.prevAttemptHeartbeatDetails = info.getHeartbeatDetails();
        this.heartbeatExecutor = heartbeatExecutor;
        this.heartbeatIntervalMillis = HeartbeatContextImpl.getHeartbeatIntervalMs(info.getHeartbeatTimeout(), maxHeartbeatThrottleInterval, defaultHeartbeatThrottleInterval);
    }

    @Override
    public <V> void heartbeat(V details) throws ActivityCompletionException {
        if (this.heartbeatExecutor.isShutdown()) {
            throw new ActivityWorkerShutdownException(this.info);
        }
        this.lock.lock();
        try {
            this.receivedAHeartbeat = true;
            this.lastDetails = details;
            this.hasOutstandingHeartbeat = true;
            if (this.scheduledHeartbeat == null) {
                this.doHeartBeatLocked(details);
            }
            if (this.lastException != null) {
                throw this.lastException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Optional<V> getHeartbeatDetails(Class<V> detailsClass, Type detailsGenericType) {
        this.lock.lock();
        try {
            if (this.receivedAHeartbeat) {
                Optional<Object> optional = Optional.ofNullable(this.lastDetails);
                return optional;
            }
            Optional<V> optional = Optional.ofNullable(this.dataConverterWithActivityContext.fromPayloads(0, this.prevAttemptHeartbeatDetails, detailsClass, detailsGenericType));
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Optional<V> getLastHeartbeatDetails(Class<V> detailsClass, Type detailsGenericType) {
        this.lock.lock();
        try {
            Optional<V> optional = Optional.ofNullable(this.dataConverterWithActivityContext.fromPayloads(0, this.prevAttemptHeartbeatDetails, detailsClass, detailsGenericType));
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getLatestHeartbeatDetails() {
        this.lock.lock();
        try {
            if (this.receivedAHeartbeat) {
                Object object = this.lastDetails;
                return object;
            }
            Object var1_2 = null;
            return var1_2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancelOutstandingHeartbeat() {
        this.lock.lock();
        try {
            if (this.scheduledHeartbeat != null) {
                this.scheduledHeartbeat.cancel(false);
                this.scheduledHeartbeat = null;
            }
            this.hasOutstandingHeartbeat = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doHeartBeatLocked(Object details) {
        long nextHeartbeatDelay;
        try {
            this.sendHeartbeatRequest(details);
            this.hasOutstandingHeartbeat = false;
            nextHeartbeatDelay = this.heartbeatIntervalMillis;
        }
        catch (StatusRuntimeException e) {
            log.warn("Heartbeat failed", (Throwable)e);
            nextHeartbeatDelay = 1000L;
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
            nextHeartbeatDelay = 1000L;
        }
        this.scheduleNextHeartbeatLocked(nextHeartbeatDelay);
    }

    private void scheduleNextHeartbeatLocked(long delay) {
        this.scheduledHeartbeat = this.heartbeatExecutor.schedule(() -> {
            this.lock.lock();
            try {
                if (this.hasOutstandingHeartbeat) {
                    this.doHeartBeatLocked(this.lastDetails);
                } else {
                    this.scheduledHeartbeat = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void sendHeartbeatRequest(Object details) {
        try {
            RecordActivityTaskHeartbeatResponse status = ActivityClientHelper.sendHeartbeatRequest(this.service, this.namespace, this.identity, this.info.getTaskToken(), this.dataConverterWithActivityContext.toPayloads(details), this.metricsScope);
            this.lastException = status.getCancelRequested() ? new ActivityCanceledException(this.info) : (status.getActivityReset() ? new ActivityResetException(this.info) : (status.getActivityPaused() ? new ActivityPausedException(this.info) : null));
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                this.lastException = new ActivityNotExistsException(this.info, (Throwable)e);
            }
            if (e.getStatus().getCode() == Status.Code.INVALID_ARGUMENT || e.getStatus().getCode() == Status.Code.FAILED_PRECONDITION) {
                this.lastException = new ActivityCompletionFailureException(this.info, (Throwable)e);
            }
            throw e;
        }
    }

    private static long getHeartbeatIntervalMs(Duration activityHeartbeatTimeout, Duration maxHeartbeatThrottleInterval, Duration defaultHeartbeatThrottleInterval) {
        long interval = activityHeartbeatTimeout.isZero() ? defaultHeartbeatThrottleInterval.toMillis() : (long)(0.8 * (double)activityHeartbeatTimeout.toMillis());
        return Math.min(interval, maxHeartbeatThrottleInterval.toMillis());
    }
}

