/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.protobuf.ByteString;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.ListWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListWorkflowExecutionsResponse;
import io.temporal.internal.client.EagerPaginator;
import io.temporal.internal.client.external.GenericWorkflowClient;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ListWorkflowExecutionIterator
extends EagerPaginator<ListWorkflowExecutionsResponse, WorkflowExecutionInfo> {
    @Nullable
    private final String query;
    @Nonnull
    private final String namespace;
    @Nullable
    private final Integer pageSize;
    @Nonnull
    private final GenericWorkflowClient genericClient;

    public ListWorkflowExecutionIterator(@Nullable String query, @Nonnull String namespace, @Nullable Integer pageSize, @Nonnull GenericWorkflowClient genericClient) {
        this.query = query;
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.pageSize = pageSize;
        this.genericClient = Objects.requireNonNull(genericClient, "genericClient");
    }

    @Override
    protected CompletableFuture<ListWorkflowExecutionsResponse> performRequest(@Nonnull ByteString nextPageToken) {
        ListWorkflowExecutionsRequest.Builder request = ListWorkflowExecutionsRequest.newBuilder().setNamespace(this.namespace).setNextPageToken(nextPageToken);
        if (this.query != null) {
            request.setQuery(this.query);
        }
        if (this.pageSize != null) {
            request.setPageSize(this.pageSize.intValue());
        }
        return this.genericClient.listWorkflowExecutionsAsync(request.build());
    }

    @Override
    protected ByteString getNextPageToken(ListWorkflowExecutionsResponse response) {
        return response.getNextPageToken();
    }

    @Override
    protected List<WorkflowExecutionInfo> toElements(ListWorkflowExecutionsResponse response) {
        return response.getExecutionsList();
    }
}

