/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.temporal.api.common.v1.Link;
import io.temporal.api.enums.v1.EventType;
import io.temporal.internal.common.ProtoEnumNameUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkConverter {
    private static final Logger log = LoggerFactory.getLogger(LinkConverter.class);
    private static final String linkPathFormat = "temporal:///namespaces/%s/workflows/%s/%s/history";
    private static final String linkReferenceTypeKey = "referenceType";
    private static final String linkEventIDKey = "eventID";
    private static final String linkEventTypeKey = "eventType";
    private static final String linkRequestIDKey = "requestID";
    private static final String eventReferenceType = Link.WorkflowEvent.EventReference.getDescriptor().getName();
    private static final String requestIDReferenceType = Link.WorkflowEvent.RequestIdReference.getDescriptor().getName();

    public static io.temporal.api.nexus.v1.Link workflowEventToNexusLink(Link.WorkflowEvent we) {
        try {
            String url = String.format(linkPathFormat, URLEncoder.encode(we.getNamespace(), StandardCharsets.UTF_8.toString()), URLEncoder.encode(we.getWorkflowId(), StandardCharsets.UTF_8.toString()), URLEncoder.encode(we.getRunId(), StandardCharsets.UTF_8.toString()));
            ArrayList<AbstractMap.SimpleImmutableEntry<String, String>> queryParams = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();
            if (we.hasEventRef()) {
                queryParams.add(new AbstractMap.SimpleImmutableEntry<String, String>(linkReferenceTypeKey, eventReferenceType));
                Link.WorkflowEvent.EventReference eventRef = we.getEventRef();
                if (eventRef.getEventId() > 0L) {
                    queryParams.add(new AbstractMap.SimpleImmutableEntry<String, String>(linkEventIDKey, String.valueOf(eventRef.getEventId())));
                }
                String eventType = URLEncoder.encode(LinkConverter.encodeEventType(eventRef.getEventType()), StandardCharsets.UTF_8.toString());
                queryParams.add(new AbstractMap.SimpleImmutableEntry<String, String>(linkEventTypeKey, eventType));
            } else if (we.hasRequestIdRef()) {
                queryParams.add(new AbstractMap.SimpleImmutableEntry<String, String>(linkReferenceTypeKey, requestIDReferenceType));
                Link.WorkflowEvent.RequestIdReference requestIDRef = we.getRequestIdRef();
                String requestID = URLEncoder.encode(requestIDRef.getRequestId(), StandardCharsets.UTF_8.toString());
                queryParams.add(new AbstractMap.SimpleImmutableEntry<String, String>(linkRequestIDKey, requestID));
                String eventType = URLEncoder.encode(LinkConverter.encodeEventType(requestIDRef.getEventType()), StandardCharsets.UTF_8.toString());
                queryParams.add(new AbstractMap.SimpleImmutableEntry<String, String>(linkEventTypeKey, eventType));
            }
            url = url + "?" + queryParams.stream().map(item -> (String)item.getKey() + "=" + (String)item.getValue()).collect(Collectors.joining("&"));
            return io.temporal.api.nexus.v1.Link.newBuilder().setUrl(url).setType(we.getDescriptorForType().getFullName()).build();
        }
        catch (Exception e) {
            log.error("Failed to encode Nexus link URL", (Throwable)e);
            return null;
        }
    }

    public static Link nexusLinkToWorkflowEvent(io.temporal.api.nexus.v1.Link nexusLink) {
        Link.Builder link = Link.newBuilder();
        try {
            URI uri = new URI(nexusLink.getUrl());
            if (!uri.getScheme().equals("temporal")) {
                log.error("Failed to parse Nexus link URL: invalid scheme: {}", (Object)uri.getScheme());
                return null;
            }
            StringTokenizer st = new StringTokenizer(uri.getRawPath(), "/");
            if (!st.nextToken().equals("namespaces")) {
                log.error("Failed to parse Nexus link URL: invalid path: {}", (Object)uri.getRawPath());
                return null;
            }
            String namespace = URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.toString());
            if (!st.nextToken().equals("workflows")) {
                log.error("Failed to parse Nexus link URL: invalid path: {}", (Object)uri.getRawPath());
                return null;
            }
            String workflowID = URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.toString());
            String runID = URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.toString());
            if (!st.hasMoreTokens() || !st.nextToken().equals("history")) {
                log.error("Failed to parse Nexus link URL: invalid path: {}", (Object)uri.getRawPath());
                return null;
            }
            Link.WorkflowEvent.Builder we = Link.WorkflowEvent.newBuilder().setNamespace(namespace).setWorkflowId(workflowID).setRunId(runID);
            Map<String, String> queryParams = LinkConverter.parseQueryParams(uri);
            String referenceType = queryParams.get(linkReferenceTypeKey);
            if (referenceType.equals(eventReferenceType)) {
                String eventType;
                Link.WorkflowEvent.EventReference.Builder eventRef = Link.WorkflowEvent.EventReference.newBuilder();
                String eventID = queryParams.get(linkEventIDKey);
                if (eventID != null && !eventID.isEmpty()) {
                    eventRef.setEventId(Long.parseLong(eventID));
                }
                if ((eventType = queryParams.get(linkEventTypeKey)) != null && !eventType.isEmpty()) {
                    eventRef.setEventType(LinkConverter.decodeEventType(eventType));
                }
                we.setEventRef(eventRef);
            } else if (referenceType.equals(requestIDReferenceType)) {
                String eventType;
                Link.WorkflowEvent.RequestIdReference.Builder requestIDRef = Link.WorkflowEvent.RequestIdReference.newBuilder();
                String requestID = queryParams.get(linkRequestIDKey);
                if (requestID != null && !requestID.isEmpty()) {
                    requestIDRef.setRequestId(requestID);
                }
                if ((eventType = queryParams.get(linkEventTypeKey)) != null && !eventType.isEmpty()) {
                    requestIDRef.setEventType(LinkConverter.decodeEventType(eventType));
                }
                we.setRequestIdRef(requestIDRef);
            } else {
                log.error("Failed to parse Nexus link URL: invalid reference type: {}", (Object)referenceType);
                return null;
            }
            link.setWorkflowEvent(we);
        }
        catch (Exception e) {
            log.error("Failed to parse Nexus link URL", (Throwable)e);
            return null;
        }
        return link.build();
    }

    private static Map<String, String> parseQueryParams(URI uri) throws UnsupportedEncodingException {
        String query = uri.getQuery();
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String pair : query.split("&")) {
            String[] kv = pair.split("=", 2);
            String key = URLDecoder.decode(kv[0], StandardCharsets.UTF_8.toString());
            String value = kv.length == 2 && !kv[1].isEmpty() ? URLDecoder.decode(kv[1], StandardCharsets.UTF_8.toString()) : null;
            queryParams.put(key, value);
        }
        return queryParams;
    }

    private static String encodeEventType(EventType eventType) {
        return ProtoEnumNameUtils.uniqueToSimplifiedName(eventType.name(), "EVENT_TYPE_");
    }

    private static EventType decodeEventType(String eventType) {
        if (eventType.startsWith("EVENT_TYPE_")) {
            return EventType.valueOf((String)eventType);
        }
        return EventType.valueOf((String)ProtoEnumNameUtils.simplifiedToUniqueName(eventType, "EVENT_TYPE_"));
    }
}

