/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import java.time.Duration;
import java.util.Objects;

public class ResourceBasedSlotOptions {
    private final int minimumSlots;
    private final int maximumSlots;
    private final Duration rampThrottle;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ResourceBasedSlotOptions(int minimumSlots, int maximumSlots, Duration rampThrottle) {
        this.minimumSlots = minimumSlots;
        this.maximumSlots = maximumSlots;
        this.rampThrottle = rampThrottle;
    }

    public int getMinimumSlots() {
        return this.minimumSlots;
    }

    public int getMaximumSlots() {
        return this.maximumSlots;
    }

    public Duration getRampThrottle() {
        return this.rampThrottle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBasedSlotOptions that = (ResourceBasedSlotOptions)o;
        return this.minimumSlots == that.minimumSlots && this.maximumSlots == that.maximumSlots && Objects.equals(this.rampThrottle, that.rampThrottle);
    }

    public int hashCode() {
        return Objects.hash(this.minimumSlots, this.maximumSlots, this.rampThrottle);
    }

    public String toString() {
        return "ResourceBasedSlotOptions{minimumSlots=" + this.minimumSlots + ", maximumSlots=" + this.maximumSlots + ", rampThrottle=" + this.rampThrottle + '}';
    }

    public static final class Builder {
        private int minimumSlots;
        private int maximumSlots;
        private Duration rampThrottle;

        private Builder() {
        }

        public Builder setMinimumSlots(int minimumSlots) {
            this.minimumSlots = minimumSlots;
            return this;
        }

        public Builder setMaximumSlots(int maximumSlots) {
            this.maximumSlots = maximumSlots;
            return this;
        }

        public Builder setRampThrottle(Duration rampThrottle) {
            this.rampThrottle = rampThrottle;
            return this;
        }

        public ResourceBasedSlotOptions build() {
            return new ResourceBasedSlotOptions(this.minimumSlots, this.maximumSlots, this.rampThrottle);
        }
    }
}

