/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.worker.tuning.SlotInfo;
import java.util.Objects;
import javax.annotation.Nonnull;

public class WorkflowSlotInfo
extends SlotInfo {
    private final String workflowType;
    private final String taskQueue;
    private final String workflowId;
    private final String runId;
    private final String workerIdentity;
    private final String workerBuildId;
    private final boolean fromStickyQueue;

    public WorkflowSlotInfo(@Nonnull PollWorkflowTaskQueueResponse response, @Nonnull PollWorkflowTaskQueueRequest request) {
        this.workflowType = response.getWorkflowType().getName();
        this.taskQueue = request.getTaskQueue().getNormalName();
        this.workflowId = response.getWorkflowExecution().getWorkflowId();
        this.runId = response.getWorkflowExecution().getRunId();
        this.workerIdentity = request.getIdentity();
        this.workerBuildId = request.getWorkerVersionCapabilities().getBuildId();
        this.fromStickyQueue = request.getTaskQueue().getKind() == TaskQueueKind.TASK_QUEUE_KIND_STICKY;
    }

    public WorkflowSlotInfo(String workflowType, String taskQueue, String workflowId, String runId, String workerIdentity, String workerBuildId, boolean fromStickyQueue) {
        this.workflowType = workflowType;
        this.taskQueue = taskQueue;
        this.workflowId = workflowId;
        this.runId = runId;
        this.workerIdentity = workerIdentity;
        this.workerBuildId = workerBuildId;
        this.fromStickyQueue = fromStickyQueue;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public String getWorkerIdentity() {
        return this.workerIdentity;
    }

    public String getWorkerBuildId() {
        return this.workerBuildId;
    }

    public boolean isFromStickyQueue() {
        return this.fromStickyQueue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowSlotInfo that = (WorkflowSlotInfo)o;
        return this.fromStickyQueue == that.fromStickyQueue && Objects.equals(this.workflowType, that.workflowType) && Objects.equals(this.taskQueue, that.taskQueue) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.runId, that.runId) && Objects.equals(this.workerIdentity, that.workerIdentity) && Objects.equals(this.workerBuildId, that.workerBuildId);
    }

    public int hashCode() {
        return Objects.hash(this.workflowType, this.taskQueue, this.workflowId, this.runId, this.workerIdentity, this.workerBuildId, this.fromStickyQueue);
    }

    public String toString() {
        return "WorkflowSlotInfo{workflowType='" + this.workflowType + '\'' + ", taskQueue='" + this.taskQueue + '\'' + ", workflowId='" + this.workflowId + '\'' + ", runId='" + this.runId + '\'' + ", workerIdentity='" + this.workerIdentity + '\'' + ", workerBuildId='" + this.workerBuildId + '\'' + ", fromStickyQueue=" + this.fromStickyQueue + '}';
    }
}

