/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.workflowservice.v1.GetWorkerBuildIdCompatibilityResponse;
import io.temporal.common.Experimental;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Experimental
public class WorkerBuildIdVersionSets {
    private final List<CompatibleSet> buildIdVersionSets;

    WorkerBuildIdVersionSets(GetWorkerBuildIdCompatibilityResponse fetchResponse) {
        this.buildIdVersionSets = Collections.unmodifiableList(fetchResponse.getMajorVersionSetsList().stream().map(majorSet -> new CompatibleSet((List<String>)majorSet.getBuildIdsList())).collect(Collectors.toList()));
    }

    public Optional<String> defaultBuildId() {
        CompatibleSet defaultSet = this.defaultSet();
        if (defaultSet == null) {
            return Optional.empty();
        }
        return defaultSet.defaultBuildId();
    }

    public CompatibleSet defaultSet() {
        if (this.buildIdVersionSets.isEmpty()) {
            return null;
        }
        return this.buildIdVersionSets.get(this.buildIdVersionSets.size() - 1);
    }

    public List<CompatibleSet> allSets() {
        return this.buildIdVersionSets;
    }

    public static class CompatibleSet {
        private final List<String> buildIds;

        CompatibleSet(List<String> buildIds) {
            this.buildIds = Collections.unmodifiableList(buildIds);
        }

        public List<String> getBuildIds() {
            return this.buildIds;
        }

        public Optional<String> defaultBuildId() {
            if (this.buildIds.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.buildIds.get(this.buildIds.size() - 1));
        }
    }
}

