/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client.external;

import com.google.common.base.Preconditions;
import com.uber.m3.tally.Scope;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.client.external.ManualActivityCompletionClientImpl;
import io.temporal.payload.context.ActivitySerializationContext;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ManualActivityCompletionClientFactoryImpl
implements ManualActivityCompletionClientFactory {
    private final WorkflowServiceStubs service;
    private final DataConverter dataConverter;
    private final String namespace;
    private final String identity;

    ManualActivityCompletionClientFactoryImpl(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String identity, @Nonnull DataConverter dataConverter) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.identity = Objects.requireNonNull(identity);
        this.dataConverter = Objects.requireNonNull(dataConverter);
    }

    @Override
    public ManualActivityCompletionClient getClient(@Nonnull byte[] taskToken, @Nonnull Scope metricsScope) {
        return this.getClient(taskToken, metricsScope, null);
    }

    @Override
    public ManualActivityCompletionClient getClient(@Nonnull byte[] taskToken, @Nonnull Scope metricsScope, @Nullable ActivitySerializationContext activitySerializationContext) {
        Preconditions.checkNotNull((Object)metricsScope, (Object)"metricsScope");
        Preconditions.checkNotNull((Object)taskToken, (Object)"taskToken");
        Preconditions.checkArgument((taskToken.length > 0 ? 1 : 0) != 0, (Object)"empty taskToken");
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, this.identity, this.dataConverter, metricsScope, taskToken, null, null, activitySerializationContext);
    }

    @Override
    public ManualActivityCompletionClient getClient(@Nonnull WorkflowExecution execution, @Nonnull String activityId, @Nonnull Scope metricsScope) {
        return this.getClient(execution, activityId, metricsScope, null);
    }

    @Override
    public ManualActivityCompletionClient getClient(@Nonnull WorkflowExecution execution, @Nonnull String activityId, @Nonnull Scope metricsScope, @Nullable ActivitySerializationContext activitySerializationContext) {
        Preconditions.checkNotNull((Object)metricsScope, (Object)"metricsScope");
        Preconditions.checkNotNull((Object)execution, (Object)"execution");
        Preconditions.checkNotNull((Object)activityId, (Object)"activityId");
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, this.identity, this.dataConverter, metricsScope, null, execution, activityId, activitySerializationContext);
    }
}

