/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.Priority;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.common.RetryOptions;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.RetryOptionsUtils;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class BasicWorkflowContext {
    private final long runStartedTimestampMillis;
    private final WorkflowExecutionStartedEventAttributes startedAttributes;
    private final String namespace;
    @Nonnull
    private final WorkflowExecution workflowExecution;
    @Nullable
    private final Payloads lastCompletionResult;
    @Nullable
    private final Failure previousRunFailure;

    BasicWorkflowContext(String namespace, @Nonnull WorkflowExecution workflowExecution, WorkflowExecutionStartedEventAttributes startedAttributes, long runStartedTimestampMillis) {
        this.namespace = namespace;
        this.workflowExecution = (WorkflowExecution)Preconditions.checkNotNull((Object)workflowExecution);
        this.startedAttributes = startedAttributes;
        this.runStartedTimestampMillis = runStartedTimestampMillis;
        this.lastCompletionResult = startedAttributes.hasLastCompletionResult() ? startedAttributes.getLastCompletionResult() : null;
        this.previousRunFailure = startedAttributes.hasContinuedFailure() ? startedAttributes.getContinuedFailure() : null;
    }

    @Nonnull
    WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    WorkflowType getWorkflowType() {
        return this.startedAttributes.getWorkflowType();
    }

    @Nonnull
    String getFirstExecutionRunId() {
        return this.startedAttributes.getFirstExecutionRunId();
    }

    Optional<String> getContinuedExecutionRunId() {
        String runId = this.startedAttributes.getContinuedExecutionRunId();
        return runId.isEmpty() ? Optional.empty() : Optional.of(runId);
    }

    @Nonnull
    String getOriginalExecutionRunId() {
        return this.startedAttributes.getOriginalExecutionRunId();
    }

    WorkflowExecution getParentWorkflowExecution() {
        return this.startedAttributes.hasParentWorkflowExecution() ? this.startedAttributes.getParentWorkflowExecution() : null;
    }

    WorkflowExecution getRootWorkflowExecution() {
        return this.startedAttributes.hasRootWorkflowExecution() ? this.startedAttributes.getRootWorkflowExecution() : null;
    }

    Duration getWorkflowRunTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.startedAttributes.getWorkflowRunTimeout());
    }

    Duration getWorkflowExecutionTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.startedAttributes.getWorkflowExecutionTimeout());
    }

    long getWorkflowExecutionExpirationTimestampMillis() {
        return Timestamps.toMillis((Timestamp)this.startedAttributes.getWorkflowExecutionExpirationTime());
    }

    long getRunStartedTimestampMillis() {
        return this.runStartedTimestampMillis;
    }

    Duration getWorkflowTaskTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.startedAttributes.getWorkflowTaskTimeout());
    }

    String getTaskQueue() {
        return this.startedAttributes.getTaskQueue().getName();
    }

    String getNamespace() {
        return this.namespace;
    }

    public Map<String, Payload> getHeader() {
        return this.startedAttributes.getHeader().getFieldsMap();
    }

    int getAttempt() {
        return this.startedAttributes.getAttempt();
    }

    public String getCronSchedule() {
        return this.startedAttributes.getCronSchedule();
    }

    @Nullable
    public Payloads getLastCompletionResult() {
        return this.lastCompletionResult;
    }

    @Nullable
    public Failure getPreviousRunFailure() {
        return this.previousRunFailure;
    }

    @Nullable
    public RetryOptions getRetryOptions() {
        if (!this.startedAttributes.hasRetryPolicy()) {
            return null;
        }
        return RetryOptionsUtils.toRetryOptions(this.startedAttributes.getRetryPolicy());
    }

    @Nonnull
    public Priority getPriority() {
        return this.startedAttributes.getPriority();
    }
}

