/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.sdk.v1.WorkflowInteractionDefinition;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.SignalHandlerInfo;
import io.temporal.workflow.DynamicSignalHandler;
import io.temporal.workflow.HandlerUnfinishedPolicy;
import io.temporal.workflow.Workflow;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignalDispatcher {
    private static final Logger log = LoggerFactory.getLogger(SignalDispatcher.class);
    private final DataConverter dataConverterWithWorkflowContext;
    private final Map<String, WorkflowOutboundCallsInterceptor.SignalRegistrationRequest> signalCallbacks = new HashMap<String, WorkflowOutboundCallsInterceptor.SignalRegistrationRequest>();
    private WorkflowInboundCallsInterceptor inboundCallsInterceptor;
    private DynamicSignalHandler dynamicSignalHandler;
    private final Queue<SignalData> signalBuffer = new ArrayDeque<SignalData>();
    private Map<Long, SignalHandlerInfo> runningSignalHandlers = new LinkedHashMap<Long, SignalHandlerInfo>();

    public SignalDispatcher(DataConverter dataConverterWithWorkflowContext) {
        this.dataConverterWithWorkflowContext = dataConverterWithWorkflowContext;
    }

    public void setInboundCallsInterceptor(WorkflowInboundCallsInterceptor inboundCallsInterceptor) {
        this.inboundCallsInterceptor = inboundCallsInterceptor;
    }

    public void handleInterceptedSignal(WorkflowInboundCallsInterceptor.SignalInput input) {
        String signalName = input.getSignalName();
        Object[] args = input.getArguments();
        WorkflowOutboundCallsInterceptor.SignalRegistrationRequest handler = this.signalCallbacks.get(signalName);
        if (handler == null) {
            if (this.dynamicSignalHandler != null) {
                this.dynamicSignalHandler.handle(signalName, (EncodedValues)args[0]);
                return;
            }
            throw new IllegalStateException("Unknown signal type: " + signalName);
        }
        handler.getCallback().apply(args);
    }

    public Map<Long, SignalHandlerInfo> getRunningSignalHandlers() {
        return this.runningSignalHandlers;
    }

    public void handleSignal(String signalName, Optional<Payloads> input, long eventId, Header header) {
        HandlerUnfinishedPolicy policy;
        Object[] args;
        WorkflowOutboundCallsInterceptor.SignalRegistrationRequest handler = this.signalCallbacks.get(signalName);
        if (signalName.startsWith(InternalUtils.TEMPORAL_RESERVED_PREFIX)) {
            return;
        }
        if (handler == null) {
            if (this.dynamicSignalHandler == null) {
                this.signalBuffer.add(new SignalData(signalName, input, eventId, header));
                return;
            }
            args = new Object[]{new EncodedValues(input, this.dataConverterWithWorkflowContext)};
            policy = this.dynamicSignalHandler.getUnfinishedPolicy(signalName);
        } else {
            try {
                args = this.dataConverterWithWorkflowContext.fromPayloads(input, handler.getArgTypes(), handler.getGenericArgTypes());
            }
            catch (DataConverterException e) {
                this.logSerializationException(signalName, eventId, e);
                return;
            }
            policy = handler.getUnfinishedPolicy();
        }
        boolean threadDestroyed = false;
        this.runningSignalHandlers.put(eventId, new SignalHandlerInfo(eventId, signalName, policy));
        try {
            this.inboundCallsInterceptor.handleSignal(new WorkflowInboundCallsInterceptor.SignalInput(signalName, args, eventId, header));
        }
        catch (DestroyWorkflowThreadError e) {
            threadDestroyed = true;
            throw e;
        }
        finally {
            if (!threadDestroyed) {
                this.runningSignalHandlers.remove(eventId);
            }
        }
    }

    public void registerSignalHandlers(WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput input) {
        for (WorkflowOutboundCallsInterceptor.SignalRegistrationRequest request : input.getRequests()) {
            String signalType = request.getSignalType();
            if (this.signalCallbacks.containsKey(signalType)) {
                throw new IllegalStateException("Signal \"" + signalType + "\" is already registered");
            }
            this.signalCallbacks.put(signalType, request);
        }
        for (SignalData signalData : this.signalBuffer) {
            this.handleSignal(signalData.getSignalName(), signalData.getPayload(), signalData.getEventId(), signalData.getHeader());
        }
    }

    public void registerDynamicSignalHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput input) {
        this.dynamicSignalHandler = input.getHandler();
        for (SignalData signalData : this.signalBuffer) {
            this.dynamicSignalHandler.handle(signalData.getSignalName(), new EncodedValues(signalData.getPayload(), this.dataConverterWithWorkflowContext));
        }
    }

    private void logSerializationException(String signalName, Long eventId, DataConverterException exception) {
        log.error("Failure deserializing signal input for \"" + signalName + "\" at eventId " + eventId + ". Dropping it.", (Throwable)exception);
        Workflow.getMetricsScope().counter("temporal_corrupted_signals").inc(1L);
    }

    public List<WorkflowInteractionDefinition> getSignalHandlers() {
        ArrayList<WorkflowInteractionDefinition> handlers = new ArrayList<WorkflowInteractionDefinition>(this.signalCallbacks.size() + 1);
        for (Map.Entry<String, WorkflowOutboundCallsInterceptor.SignalRegistrationRequest> entry : this.signalCallbacks.entrySet()) {
            WorkflowOutboundCallsInterceptor.SignalRegistrationRequest handler = entry.getValue();
            handlers.add(WorkflowInteractionDefinition.newBuilder().setName(handler.getSignalType()).setDescription(handler.getDescription()).build());
        }
        if (this.dynamicSignalHandler != null) {
            handlers.add(WorkflowInteractionDefinition.newBuilder().setDescription(this.dynamicSignalHandler.getDescription()).build());
        }
        handlers.sort(Comparator.comparing(WorkflowInteractionDefinition::getName));
        return handlers;
    }

    private static class SignalData {
        private final String signalName;
        private final Optional<Payloads> payload;
        private final long eventId;
        private final Header header;

        private SignalData(String signalName, Optional<Payloads> payload, long eventId, Header header) {
            this.signalName = Objects.requireNonNull(signalName);
            this.payload = Objects.requireNonNull(payload);
            this.eventId = eventId;
            this.header = header;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Optional<Payloads> getPayload() {
            return this.payload;
        }

        public long getEventId() {
            return this.eventId;
        }

        public Header getHeader() {
            return this.header;
        }
    }
}

