/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import java.util.concurrent.Semaphore;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AdjustableSemaphore {
    private final ResizeableSemaphore semaphore;
    private int maxPermits = 0;

    public AdjustableSemaphore(int initialPermits) {
        if (initialPermits < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + initialPermits);
        }
        this.maxPermits = initialPermits;
        this.semaphore = new ResizeableSemaphore(initialPermits);
    }

    synchronized void setMaxPermits(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + newMax);
        }
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            this.semaphore.reducePermits(Math.abs(delta));
        }
        this.maxPermits = newMax;
    }

    void release() {
        this.semaphore.release();
    }

    void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1L;

        ResizeableSemaphore(int initialPermits) {
            super(initialPermits);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

