/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.grpc.Context;
import io.temporal.api.common.v1.WorkerVersionCapabilities;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.GrpcUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.AsyncPoller;
import io.temporal.internal.worker.DisableNormalPolling;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerVersioningOptions;
import io.temporal.internal.worker.WorkerVersioningProtoUtils;
import io.temporal.internal.worker.WorkflowTask;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.PollerTypeMetricsTag;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWorkflowPollTask
implements AsyncPoller.PollTaskAsync<WorkflowTask>,
DisableNormalPolling {
    private static final Logger log = LoggerFactory.getLogger(AsyncWorkflowPollTask.class);
    private final TrackingSlotSupplier<?> slotSupplier;
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;
    private final Scope pollerMetricScope;
    private final PollWorkflowTaskQueueRequest pollRequest;
    private final AtomicInteger pollGauge = new AtomicInteger();
    private final MetricsTag.TagValue taskQueueTagValue;
    private final boolean stickyPoller;
    private final Context.CancellableContext grpcContext = Context.ROOT.withCancellation();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public String toString() {
        return "AsyncWorkflowPollTask{stickyPoller=" + this.stickyPoller + '}';
    }

    public AsyncWorkflowPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nullable String stickyTaskQueue, @Nonnull String identity, @Nonnull WorkerVersioningOptions versioningOptions, @Nonnull TrackingSlotSupplier<WorkflowSlotInfo> slotSupplier, @Nonnull Scope metricsScope, @Nonnull Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities) {
        this.service = service;
        this.slotSupplier = slotSupplier;
        this.metricsScope = metricsScope;
        PollWorkflowTaskQueueRequest.Builder pollRequestBuilder = PollWorkflowTaskQueueRequest.newBuilder().setNamespace(Objects.requireNonNull(namespace)).setIdentity(Objects.requireNonNull(identity));
        if (versioningOptions.getWorkerDeploymentOptions() != null) {
            pollRequestBuilder.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(versioningOptions.getWorkerDeploymentOptions()));
        } else if (serverCapabilities.get().getBuildIdBasedVersioning()) {
            pollRequestBuilder.setWorkerVersionCapabilities(WorkerVersionCapabilities.newBuilder().setBuildId(versioningOptions.getBuildId()).setUseVersioning(versioningOptions.isUsingVersioning()).build());
        } else {
            pollRequestBuilder.setBinaryChecksum(versioningOptions.getBuildId());
        }
        boolean bl = this.stickyPoller = stickyTaskQueue != null && !stickyTaskQueue.isEmpty();
        if (!this.stickyPoller) {
            this.taskQueueTagValue = PollerTypeMetricsTag.PollerType.WORKFLOW_TASK;
            this.pollRequest = pollRequestBuilder.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue).setKind(TaskQueueKind.TASK_QUEUE_KIND_NORMAL).build()).build();
            this.pollerMetricScope = metricsScope.tagged((Map)new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)String.format("%s:%s", taskQueue, "sticky")).build());
        } else {
            this.taskQueueTagValue = PollerTypeMetricsTag.PollerType.WORKFLOW_STICKY_TASK;
            this.pollRequest = pollRequestBuilder.setTaskQueue(TaskQueue.newBuilder().setName(stickyTaskQueue).setKind(TaskQueueKind.TASK_QUEUE_KIND_STICKY).setNormalName(taskQueue).build()).build();
            this.pollerMetricScope = metricsScope;
        }
    }

    @Override
    public CompletableFuture<WorkflowTask> poll(SlotPermit permit) throws AsyncPoller.PollTaskAsyncAbort {
        if (this.shutdown.get()) {
            throw new AsyncPoller.PollTaskAsyncAbort("Normal poller is disabled");
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + this.pollRequest);
        }
        MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)this.taskQueueTagValue).gauge("temporal_num_pollers").update((double)this.pollGauge.incrementAndGet());
        CompletableFuture response = null;
        try {
            response = (CompletableFuture)this.grpcContext.call(() -> GrpcUtils.toCompletableFuture(((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollWorkflowTaskQueue(this.pollRequest)));
        }
        catch (Exception e2) {
            MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)this.taskQueueTagValue).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet());
            throw new RuntimeException(e2);
        }
        return ((CompletableFuture)response.thenApply(r -> {
            if (r == null || r.getTaskToken().isEmpty()) {
                this.pollerMetricScope.counter("temporal_workflow_task_queue_poll_empty").inc(1L);
                return null;
            }
            this.pollerMetricScope.counter("temporal_workflow_task_queue_poll_succeed").inc(1L);
            this.pollerMetricScope.timer("temporal_workflow_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(r.getStartedTime(), r.getScheduledTime()));
            return new WorkflowTask((PollWorkflowTaskQueueResponse)r, reason -> this.slotSupplier.releaseSlot((SlotReleaseReason)reason, permit));
        })).whenComplete((r, e) -> MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)this.taskQueueTagValue).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet()));
    }

    @Override
    public void cancel(Throwable cause) {
        this.grpcContext.cancel(cause);
    }

    @Override
    public void disableNormalPoll() {
        if (this.stickyPoller) {
            throw new IllegalStateException("Cannot disable normal poll for sticky poller");
        }
        this.shutdown.set(true);
    }

    @Override
    public String getLabel() {
        return this.stickyPoller ? "StickyWorkflowPollTask" : "NormalWorkflowPollTask";
    }
}

