/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.common.GrpcUtils;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.ShutdownableTaskExecutor;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.TaskExecutor;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplierFuture;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasePoller<T>
implements SuspendableWorker {
    private static final Logger log = LoggerFactory.getLogger(BasePoller.class);
    protected final AtomicReference<CountDownLatch> suspendLatch = new AtomicReference();
    protected TaskExecutor<T> taskExecutor;
    protected ExecutorService pollExecutor;

    protected BasePoller(ShutdownableTaskExecutor<T> taskExecutor) {
        Objects.requireNonNull(taskExecutor, "taskExecutor should not be null");
        this.taskExecutor = taskExecutor;
    }

    @Override
    public abstract boolean start();

    @Override
    public boolean isShutdown() {
        return this.pollExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.pollExecutor.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        log.info("shutdown: {}", (Object)this);
        WorkerLifecycleState lifecycleState = this.getLifecycleState();
        switch (lifecycleState) {
            case NOT_STARTED: 
            case TERMINATED: {
                return CompletableFuture.completedFuture(null);
            }
        }
        return shutdownManager.shutdownExecutorNow(this.pollExecutor, this + "#pollExecutor", Duration.ofSeconds(1L)).exceptionally(e -> {
            log.error("Unexpected exception during shutdown", e);
            return null;
        });
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        WorkerLifecycleState lifecycleState = this.getLifecycleState();
        switch (lifecycleState) {
            case NOT_STARTED: 
            case TERMINATED: {
                return;
            }
        }
        long timeoutMillis = unit.toMillis(timeout);
        ShutdownManager.awaitTermination(this.pollExecutor, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        if (this.suspendLatch.compareAndSet(null, new CountDownLatch(1))) {
            log.info("Suspend Polling: {}", (Object)this);
        } else {
            log.info("Polling is already suspended: {}", (Object)this);
        }
    }

    @Override
    public void resumePolling() {
        CountDownLatch existing = this.suspendLatch.getAndSet(null);
        if (existing != null) {
            log.info("Resume Polling {}", (Object)this);
            existing.countDown();
        }
    }

    @Override
    public boolean isSuspended() {
        return this.suspendLatch.get() != null;
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        if (this.pollExecutor == null) {
            return WorkerLifecycleState.NOT_STARTED;
        }
        if (this.suspendLatch.get() != null) {
            return WorkerLifecycleState.SUSPENDED;
        }
        if (this.pollExecutor.isShutdown()) {
            if (this.pollExecutor.isTerminated()) {
                return WorkerLifecycleState.TERMINATED;
            }
            return WorkerLifecycleState.SHUTDOWN;
        }
        return WorkerLifecycleState.ACTIVE;
    }

    protected boolean shouldTerminate() {
        return this.pollExecutor.isShutdown() || Thread.currentThread().isInterrupted();
    }

    static SlotPermit getSlotPermitAndHandleInterrupts(SlotSupplierFuture future, TrackingSlotSupplier<?> slotSupplier) {
        SlotPermit permit;
        try {
            permit = (SlotPermit)future.get();
        }
        catch (InterruptedException e) {
            SlotPermit maybePermitAnyway = future.abortReservation();
            if (maybePermitAnyway != null) {
                slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), maybePermitAnyway);
            }
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            log.warn("Error while trying to reserve a slot", e.getCause());
            return null;
        }
        return permit;
    }

    static boolean shouldIgnoreDuringShutdown(Throwable ex) {
        if (ex instanceof StatusRuntimeException && (GrpcUtils.isChannelShutdownException((StatusRuntimeException)ex) || ((StatusRuntimeException)ex).getStatus().getCode().equals((Object)Status.Code.CANCELLED))) {
            return true;
        }
        return ex instanceof RejectedExecutionException || ex instanceof InterruptedException || ex.getCause() instanceof InterruptedException;
    }

    protected final class PollerUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected PollerUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!BasePoller.this.pollExecutor.isShutdown() || !BasePoller.shouldIgnoreDuringShutdown(e)) {
                this.logPollErrors(t, e);
            } else {
                this.logPollExceptionsSuppressedDuringShutdown(t, e);
            }
        }

        private void logPollErrors(Thread t, Throwable e) {
            StatusRuntimeException te;
            if (e instanceof StatusRuntimeException && (te = (StatusRuntimeException)e).getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                log.info("DEADLINE_EXCEEDED in poller thread {}", (Object)t.getName(), (Object)e);
                return;
            }
            log.warn("Failure in poller thread {}", (Object)t.getName(), (Object)e);
        }

        private void logPollExceptionsSuppressedDuringShutdown(Thread t, Throwable e) {
            log.trace("Failure in thread {} is suppressed, considered normal during shutdown", (Object)t.getName(), (Object)e);
        }
    }
}

