/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common;

import io.temporal.common.MethodRetry;
import io.temporal.failure.ActivityFailure;
import io.temporal.failure.ApplicationFailure;
import io.temporal.failure.ChildWorkflowFailure;
import io.temporal.internal.common.OptionsUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public final class RetryOptions {
    private static final double DEFAULT_BACKOFF_COEFFICIENT = 2.0;
    private static final int DEFAULT_MAXIMUM_MULTIPLIER = 100;
    private static final RetryOptions DEFAULT_INSTANCE = RetryOptions.newBuilder().build();
    private final Duration initialInterval;
    private final double backoffCoefficient;
    private final int maximumAttempts;
    private final Duration maximumInterval;
    private final String[] doNotRetry;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Builder newBuilder(RetryOptions options) {
        return new Builder(options);
    }

    public static RetryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static RetryOptions merge(MethodRetry r, RetryOptions o) {
        double coefficient;
        Duration maximum;
        if (r == null) {
            if (o == null) {
                return null;
            }
            return o;
        }
        if (o == null) {
            o = RetryOptions.getDefaultInstance();
        }
        Duration initial = OptionsUtils.merge(r.initialIntervalSeconds(), o.getInitialInterval());
        Builder builder = RetryOptions.newBuilder();
        if (initial != null) {
            builder.setInitialInterval(initial);
        }
        if ((maximum = OptionsUtils.merge(r.maximumIntervalSeconds(), o.getMaximumInterval())) != null) {
            builder.setMaximumInterval(maximum);
        }
        if ((coefficient = OptionsUtils.merge(r.backoffCoefficient(), o.getBackoffCoefficient(), Double.TYPE).doubleValue()) != 0.0) {
            builder.setBackoffCoefficient(coefficient);
        } else {
            builder.setBackoffCoefficient(2.0);
        }
        return builder.setMaximumAttempts(OptionsUtils.merge(r.maximumAttempts(), o.getMaximumAttempts(), Integer.TYPE)).setDoNotRetry(OptionsUtils.merge(r.doNotRetry(), o.getDoNotRetry())).build();
    }

    public RetryOptions merge(RetryOptions o) {
        if (o == null) {
            return this;
        }
        return RetryOptions.newBuilder().setInitialInterval(OptionsUtils.merge(this.getInitialInterval(), o.getInitialInterval(), Duration.class)).setMaximumInterval(OptionsUtils.merge(this.getMaximumInterval(), o.getMaximumInterval(), Duration.class)).setBackoffCoefficient(OptionsUtils.merge(this.getBackoffCoefficient(), o.getBackoffCoefficient(), Double.TYPE)).setMaximumAttempts(OptionsUtils.merge(this.getMaximumAttempts(), o.getMaximumAttempts(), Integer.TYPE)).setDoNotRetry(OptionsUtils.merge(this.getDoNotRetry(), o.getDoNotRetry())).build();
    }

    private RetryOptions(Duration initialInterval, double backoffCoefficient, int maximumAttempts, Duration maximumInterval, String[] doNotRetry) {
        this.initialInterval = initialInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.maximumAttempts = maximumAttempts;
        this.maximumInterval = maximumInterval;
        this.doNotRetry = doNotRetry;
    }

    public Duration getInitialInterval() {
        return this.initialInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Duration getMaximumInterval() {
        return this.maximumInterval;
    }

    public String[] getDoNotRetry() {
        return this.doNotRetry;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "RetryOptions{initialInterval=" + this.initialInterval + ", backoffCoefficient=" + this.backoffCoefficient + ", maximumAttempts=" + this.maximumAttempts + ", maximumInterval=" + this.maximumInterval + ", doNotRetry=" + Arrays.toString(this.doNotRetry) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryOptions that = (RetryOptions)o;
        return Double.compare(that.backoffCoefficient, this.backoffCoefficient) == 0 && this.maximumAttempts == that.maximumAttempts && Objects.equals(this.initialInterval, that.initialInterval) && Objects.equals(this.maximumInterval, that.maximumInterval) && Arrays.equals(this.doNotRetry, that.doNotRetry);
    }

    public int hashCode() {
        return Objects.hash(this.initialInterval, this.backoffCoefficient, this.maximumAttempts, this.maximumInterval, Arrays.hashCode(this.doNotRetry));
    }

    public long calculateSleepTime(long attempt) {
        double coefficient = this.backoffCoefficient == 0.0 ? 2.0 : this.backoffCoefficient;
        double sleepMillis = Math.pow(coefficient, attempt - 1L) * (double)this.initialInterval.toMillis();
        if (this.maximumInterval == null) {
            return (long)Math.min(sleepMillis, (double)(this.initialInterval.toMillis() * 100L));
        }
        return Math.min((long)sleepMillis, this.maximumInterval.toMillis());
    }

    public boolean shouldRethrow(Throwable e, Optional<Duration> expiration, long attempt, long elapsed, long sleepTime) {
        if (e instanceof ActivityFailure || e instanceof ChildWorkflowFailure) {
            e = e.getCause();
        }
        String type = e instanceof ApplicationFailure ? ((ApplicationFailure)e).getType() : e.getClass().getName();
        if (this.doNotRetry != null) {
            for (String doNotRetry : this.doNotRetry) {
                if (!doNotRetry.equals(type)) continue;
                return true;
            }
        }
        if (this.maximumAttempts != 0 && attempt >= (long)this.maximumAttempts) {
            return true;
        }
        return expiration.isPresent() && elapsed + sleepTime >= expiration.get().toMillis();
    }

    public static final class Builder {
        private static final Duration DEFAULT_INITIAL_INTERVAL = Duration.ofSeconds(1L);
        private Duration initialInterval;
        private double backoffCoefficient;
        private int maximumAttempts;
        private Duration maximumInterval;
        private String[] doNotRetry;

        private Builder(RetryOptions options) {
            if (options == null) {
                return;
            }
            this.backoffCoefficient = options.getBackoffCoefficient();
            this.maximumAttempts = options.getMaximumAttempts();
            this.initialInterval = options.getInitialInterval();
            this.maximumInterval = options.getMaximumInterval();
            this.doNotRetry = options.getDoNotRetry();
        }

        public Builder setInitialInterval(Duration initialInterval) {
            Objects.requireNonNull(initialInterval);
            if (initialInterval.isNegative() || initialInterval.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + initialInterval);
            }
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (backoffCoefficient < 1.0) {
                throw new IllegalArgumentException("coefficient less than 1.0: " + backoffCoefficient);
            }
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setMaximumAttempts(int maximumAttempts) {
            if (maximumAttempts < 0) {
                throw new IllegalArgumentException("Invalid maximumAttempts: " + maximumAttempts);
            }
            this.maximumAttempts = maximumAttempts;
            return this;
        }

        public Builder setMaximumInterval(Duration maximumInterval) {
            if (maximumInterval != null && (maximumInterval.isNegative() || maximumInterval.isZero())) {
                throw new IllegalArgumentException("Invalid interval: " + maximumInterval);
            }
            this.maximumInterval = maximumInterval;
            return this;
        }

        public Builder setDoNotRetry(String ... doNotRetry) {
            if (doNotRetry != null) {
                this.doNotRetry = doNotRetry;
            }
            return this;
        }

        public RetryOptions build() {
            return new RetryOptions(this.initialInterval, this.backoffCoefficient, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
        }

        public RetryOptions validateBuildWithDefaults() {
            double backoff = this.backoffCoefficient;
            if (backoff == 0.0) {
                backoff = 2.0;
            }
            return new RetryOptions(this.initialInterval == null || this.initialInterval.isZero() ? DEFAULT_INITIAL_INTERVAL : this.initialInterval, backoff, this.maximumAttempts, this.maximumInterval, this.doNotRetry == null ? new String[]{} : this.doNotRetry);
        }
    }
}

