/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;

public class DataConverterException
extends RuntimeException {
    public static final int MESSAGE_TRUNCATION_SIZE = 255;

    public DataConverterException(Payload content, Type[] valueTypes, Throwable cause) {
        super(DataConverterException.toMessage(null, content, valueTypes), cause);
    }

    public DataConverterException(Throwable cause) {
        super(cause);
    }

    public DataConverterException(String message, Throwable cause) {
        super(message, cause);
    }

    public DataConverterException(String message, Payload content, Type[] valueTypes) {
        super(DataConverterException.toMessage(message, content, valueTypes));
    }

    public DataConverterException(String message, Optional<Payloads> content, Type valueType) {
        super(DataConverterException.toMessage(message, content, valueType));
    }

    public DataConverterException(String message, Optional<Payloads> content, Type[] valueTypes) {
        super(DataConverterException.toMessage(message, content, valueTypes));
    }

    public <T> DataConverterException(Payload payload, Class<T> valueClass, Throwable e) {
        super(DataConverterException.toMessage(e.getMessage(), payload, new Type[]{valueClass}), e);
    }

    private static String toMessage(String message, Optional<Payloads> content, Type[] valueTypes) {
        if (content == null && valueTypes == null || valueTypes.length == 0) {
            return message;
        }
        StringBuilder result = new StringBuilder();
        if (message != null && message.length() > 0) {
            result.append(message);
            result.append(" ");
        }
        result.append("when parsing:\"");
        result.append(DataConverterException.truncateContent(content));
        result.append("\" into following types: ");
        result.append(Arrays.toString(valueTypes));
        return result.toString();
    }

    private static String toMessage(String message, Optional<Payloads> content, Type valueType) {
        if (!content.isPresent() && valueType == null) {
            return message;
        }
        StringBuilder result = new StringBuilder();
        if (message != null && message.length() > 0) {
            result.append(message);
            result.append(" ");
        }
        result.append("when parsing:\"");
        result.append(DataConverterException.truncateContent(content));
        result.append("\" into following types: ");
        result.append(valueType);
        return result.toString();
    }

    private static String toMessage(String message, Payload content, Type[] valueTypes) {
        if (content == null && valueTypes == null) {
            return message;
        }
        StringBuilder result = new StringBuilder();
        if (message != null && message.length() > 0) {
            result.append(message);
            result.append(" ");
        }
        result.append("when parsing:\"");
        result.append(DataConverterException.truncateContent(content));
        result.append("\" into following types: ");
        result.append(Arrays.toString(valueTypes));
        return result.toString();
    }

    private static String truncateContent(Optional<Payloads> content) {
        if (!content.isPresent()) {
            return "<EMPTY PAYLOAD>";
        }
        String data = content.get().getPayloadsCount() == 1 ? content.get().getPayloads(0).getData().toString(StandardCharsets.UTF_8) : String.valueOf(content);
        int maxIndex = Math.min(data.length(), 255);
        return data.substring(0, maxIndex);
    }

    private static String truncateContent(Payload content) {
        if (content == null) {
            return "";
        }
        String data = content.getData().toString(StandardCharsets.UTF_8);
        int maxIndex = Math.min(data.length(), 255);
        return data.substring(0, maxIndex);
    }
}

