/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.interceptors;

import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.interceptors.Header;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.DynamicQueryHandler;
import io.temporal.workflow.DynamicSignalHandler;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

public interface WorkflowOutboundCallsInterceptor {
    public <R> ActivityOutput<R> executeActivity(ActivityInput<R> var1);

    public <R> LocalActivityOutput<R> executeLocalActivity(LocalActivityInput<R> var1);

    public <R> ChildWorkflowOutput<R> executeChildWorkflow(ChildWorkflowInput<R> var1);

    public Random newRandom();

    public SignalExternalOutput signalExternalWorkflow(SignalExternalInput var1);

    public CancelWorkflowOutput cancelWorkflow(CancelWorkflowInput var1);

    public void sleep(Duration var1);

    public boolean await(Duration var1, String var2, Supplier<Boolean> var3);

    public void await(String var1, Supplier<Boolean> var2);

    public Promise<Void> newTimer(Duration var1);

    public <R> R sideEffect(Class<R> var1, Type var2, Functions.Func<R> var3);

    public <R> R mutableSideEffect(String var1, Class<R> var2, Type var3, BiPredicate<R, R> var4, Functions.Func<R> var5);

    public int getVersion(String var1, int var2, int var3);

    public void continueAsNew(ContinueAsNewInput var1);

    public void registerQuery(RegisterQueryInput var1);

    public void registerSignalHandlers(RegisterSignalHandlersInput var1);

    public void registerDynamicSignalHandler(RegisterDynamicSignalHandlerInput var1);

    public void registerDynamicQueryHandler(RegisterDynamicQueryHandlerInput var1);

    public UUID randomUUID();

    public void upsertSearchAttributes(Map<String, Object> var1);

    public Object newChildThread(Runnable var1, boolean var2, String var3);

    public long currentTimeMillis();

    public static final class RegisterDynamicSignalHandlerInput {
        private final DynamicSignalHandler handler;

        public RegisterDynamicSignalHandlerInput(DynamicSignalHandler handler) {
            this.handler = handler;
        }

        public DynamicSignalHandler getHandler() {
            return this.handler;
        }
    }

    public static final class RegisterDynamicQueryHandlerInput {
        private final DynamicQueryHandler handler;

        public RegisterDynamicQueryHandlerInput(DynamicQueryHandler handler) {
            this.handler = handler;
        }

        public DynamicQueryHandler getHandler() {
            return this.handler;
        }
    }

    public static final class RegisterQueryInput {
        private final String queryType;
        private final Class<?>[] argTypes;
        private final Type[] genericArgTypes;
        private final Functions.Func1<Object[], Object> callback;

        public RegisterQueryInput(String queryType, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Func1<Object[], Object> callback) {
            this.queryType = queryType;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Type[] getGenericArgTypes() {
            return this.genericArgTypes;
        }

        public Functions.Func1<Object[], Object> getCallback() {
            return this.callback;
        }
    }

    public static final class RegisterSignalHandlersInput {
        private final List<SignalRegistrationRequest> requests;

        public RegisterSignalHandlersInput(List<SignalRegistrationRequest> requests) {
            this.requests = requests;
        }

        public List<SignalRegistrationRequest> getRequests() {
            return this.requests;
        }
    }

    public static final class SignalRegistrationRequest {
        private final String signalType;
        private final Class<?>[] argTypes;
        private final Type[] genericArgTypes;
        private final Functions.Proc1<Object[]> callback;

        public SignalRegistrationRequest(String signalType, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> callback) {
            this.signalType = signalType;
            this.argTypes = argTypes;
            this.genericArgTypes = genericArgTypes;
            this.callback = callback;
        }

        public String getSignalType() {
            return this.signalType;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Type[] getGenericArgTypes() {
            return this.genericArgTypes;
        }

        public Functions.Proc1<Object[]> getCallback() {
            return this.callback;
        }
    }

    public static final class ContinueAsNewInput {
        private final Optional<String> workflowType;
        private final Optional<ContinueAsNewOptions> options;
        private final Object[] args;
        private final Header header;

        public ContinueAsNewInput(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args, Header header) {
            this.workflowType = workflowType;
            this.options = options;
            this.args = args;
            this.header = header;
        }

        public Optional<String> getWorkflowType() {
            return this.workflowType;
        }

        public Optional<ContinueAsNewOptions> getOptions() {
            return this.options;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public static final class CancelWorkflowOutput {
        private final Promise<Void> result;

        public CancelWorkflowOutput(Promise<Void> result) {
            this.result = result;
        }

        public Promise<Void> getResult() {
            return this.result;
        }
    }

    public static final class CancelWorkflowInput {
        private final WorkflowExecution execution;

        public CancelWorkflowInput(WorkflowExecution execution) {
            this.execution = execution;
        }

        public WorkflowExecution getExecution() {
            return this.execution;
        }
    }

    public static final class SignalExternalOutput {
        private final Promise<Void> result;

        public SignalExternalOutput(Promise<Void> result) {
            this.result = result;
        }

        public Promise<Void> getResult() {
            return this.result;
        }
    }

    public static final class SignalExternalInput {
        private final WorkflowExecution execution;
        private final String signalName;
        private final Object[] args;

        public SignalExternalInput(WorkflowExecution execution, String signalName, Object[] args) {
            this.execution = execution;
            this.signalName = signalName;
            this.args = args;
        }

        public WorkflowExecution getExecution() {
            return this.execution;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    public static final class ChildWorkflowOutput<R> {
        private final Promise<R> result;
        private final Promise<WorkflowExecution> workflowExecution;

        public ChildWorkflowOutput(Promise<R> result, Promise<WorkflowExecution> workflowExecution) {
            this.result = result;
            this.workflowExecution = workflowExecution;
        }

        public Promise<R> getResult() {
            return this.result;
        }

        public Promise<WorkflowExecution> getWorkflowExecution() {
            return this.workflowExecution;
        }
    }

    public static final class ChildWorkflowInput<R> {
        private final String workflowId;
        private final String workflowType;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object[] args;
        private final ChildWorkflowOptions options;
        private final Header header;

        public ChildWorkflowInput(String workflowId, String workflowType, Class<R> resultClass, Type resultType, Object[] args, ChildWorkflowOptions options, Header header) {
            this.workflowId = workflowId;
            this.workflowType = workflowType;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.args = args;
            this.options = options;
            this.header = header;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public String getWorkflowType() {
            return this.workflowType;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public ChildWorkflowOptions getOptions() {
            return this.options;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public static final class LocalActivityOutput<R> {
        private final Promise<R> result;

        public LocalActivityOutput(Promise<R> result) {
            this.result = result;
        }

        public Promise<R> getResult() {
            return this.result;
        }
    }

    public static final class LocalActivityInput<R> {
        private final String activityName;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object[] args;
        private final LocalActivityOptions options;
        private final Header header;

        public LocalActivityInput(String activityName, Class<R> resultClass, Type resultType, Object[] args, LocalActivityOptions options, Header header) {
            this.activityName = activityName;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.args = args;
            this.options = options;
            this.header = header;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public LocalActivityOptions getOptions() {
            return this.options;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public static final class ActivityOutput<R> {
        private final Promise<R> result;

        public ActivityOutput(Promise<R> result) {
            this.result = result;
        }

        public Promise<R> getResult() {
            return this.result;
        }
    }

    public static final class ActivityInput<R> {
        private final String activityName;
        private final Class<R> resultClass;
        private final Type resultType;
        private final Object[] args;
        private final ActivityOptions options;
        private final Header header;

        public ActivityInput(String activityName, Class<R> resultClass, Type resultType, Object[] args, ActivityOptions options, Header header) {
            this.activityName = activityName;
            this.resultClass = resultClass;
            this.resultType = resultType;
            this.args = args;
            this.options = options;
            this.header = header;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public ActivityOptions getOptions() {
            return this.options;
        }

        public Header getHeader() {
            return this.header;
        }
    }
}

