/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.HistoryEventFilterType;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.common.RetryOptions;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.SerializerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

final class RootWorkflowClientHelper {
    private final WorkflowClientOptions clientOptions;

    public RootWorkflowClientHelper(WorkflowClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    StartWorkflowExecutionRequest newStartWorkflowExecutionRequest(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        RetryOptions retryOptions;
        String taskQueue;
        WorkflowOptions options = input.getOptions();
        StartWorkflowExecutionRequest.Builder request = StartWorkflowExecutionRequest.newBuilder().setWorkflowId(input.getWorkflowId()).setWorkflowType(WorkflowType.newBuilder().setName(input.getWorkflowType())).setRequestId(UUID.randomUUID().toString()).setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowRunTimeout())).setWorkflowExecutionTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowExecutionTimeout())).setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowTaskTimeout()));
        if (this.clientOptions.getIdentity() != null) {
            request.setIdentity(this.clientOptions.getIdentity());
        }
        if (this.clientOptions.getNamespace() != null) {
            request.setNamespace(this.clientOptions.getNamespace());
        }
        Optional<Payloads> inputArgs = this.clientOptions.getDataConverter().toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((StartWorkflowExecutionRequest.Builder)request).setInput(arg_0));
        if (options.getWorkflowIdReusePolicy() != null) {
            request.setWorkflowIdReusePolicy(options.getWorkflowIdReusePolicy());
        }
        if ((taskQueue = options.getTaskQueue()) != null && !taskQueue.isEmpty()) {
            request.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue).build());
        }
        if ((retryOptions = options.getRetryOptions()) != null) {
            request.setRetryPolicy(SerializerUtils.toRetryPolicy(retryOptions));
        }
        if (!Strings.isNullOrEmpty((String)options.getCronSchedule())) {
            request.setCronSchedule(options.getCronSchedule());
        }
        if (options.getMemo() != null) {
            request.setMemo(Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(this.clientOptions.getDataConverter(), options.getMemo())));
        }
        if (options.getSearchAttributes() != null) {
            request.setSearchAttributes(SearchAttributes.newBuilder().putAllIndexedFields(HeaderUtils.intoPayloadMap(DataConverter.getDefaultInstance(), options.getSearchAttributes())));
        }
        Header grpcHeader = HeaderUtils.toHeaderGrpc(input.getHeader(), this.extractContextsAndConvertToBytes(options.getContextPropagators()));
        request.setHeader(grpcHeader);
        return request.build();
    }

    public GetWorkflowExecutionHistoryRequest newHistoryLongPollRequest(WorkflowExecution workflowExecution, ByteString pageToken) {
        return GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setExecution(workflowExecution).setHistoryEventFilterType(HistoryEventFilterType.HISTORY_EVENT_FILTER_TYPE_CLOSE_EVENT).setWaitNewEvent(true).setNextPageToken(pageToken).build();
    }

    private io.temporal.common.interceptors.Header extractContextsAndConvertToBytes(List<ContextPropagator> workflowOptionsContextPropagators) {
        List<ContextPropagator> workflowClientContextPropagators = this.clientOptions.getContextPropagators();
        if (workflowClientContextPropagators.isEmpty() && workflowOptionsContextPropagators == null || workflowOptionsContextPropagators != null && workflowOptionsContextPropagators.isEmpty()) {
            return null;
        }
        List listToUse = (List)MoreObjects.firstNonNull(workflowOptionsContextPropagators, workflowClientContextPropagators);
        HashMap<String, Payload> result = new HashMap<String, Payload>();
        for (ContextPropagator propagator : listToUse) {
            result.putAll(propagator.serializeContext(propagator.getCurrentContext()));
        }
        return new io.temporal.common.interceptors.Header(result);
    }
}

