/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Deadline;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.RootWorkflowClientHelper;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.rpcretry.DefaultStubLongPollRpcRetryOptions;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class WorkflowClientLongPollAsyncHelper {
    WorkflowClientLongPollAsyncHelper() {
    }

    static CompletableFuture<Optional<Payloads>> getWorkflowExecutionResultAsync(WorkflowServiceStubs service, RootWorkflowClientHelper workflowClientHelper, WorkflowExecution workflowExecution, Optional<String> workflowType, long timeout, TimeUnit unit, DataConverter converter) {
        return WorkflowClientLongPollAsyncHelper.getInstanceCloseEventAsync(service, workflowClientHelper, workflowExecution, ByteString.EMPTY, timeout, unit).thenApply(closeEvent -> WorkflowExecutionUtils.getResultFromCloseEvent(workflowExecution, workflowType, closeEvent, converter));
    }

    private static CompletableFuture<HistoryEvent> getInstanceCloseEventAsync(WorkflowServiceStubs service, RootWorkflowClientHelper workflowClientHelper, WorkflowExecution workflowExecution, ByteString pageToken, long timeout, TimeUnit unit) {
        long start = System.currentTimeMillis();
        GetWorkflowExecutionHistoryRequest request = workflowClientHelper.newHistoryLongPollRequest(workflowExecution, pageToken);
        CompletableFuture<GetWorkflowExecutionHistoryResponse> response = WorkflowClientLongPollAsyncHelper.getWorkflowExecutionHistoryAsync(service, request, timeout, unit);
        return response.thenComposeAsync(r -> {
            if (timeout != 0L && System.currentTimeMillis() - start > unit.toMillis(timeout)) {
                throw CheckedExceptionWrapper.wrap((Throwable)new TimeoutException("WorkflowId=" + workflowExecution.getWorkflowId() + ", runId=" + workflowExecution.getRunId() + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit)));
            }
            History history = r.getHistory();
            if (history.getEventsCount() == 0) {
                return WorkflowClientLongPollAsyncHelper.getInstanceCloseEventAsync(service, workflowClientHelper, workflowExecution, pageToken, timeout, unit);
            }
            HistoryEvent event = history.getEvents(0);
            if (!WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)event)) {
                throw new RuntimeException("Last history event is not completion event: " + event);
            }
            if (event.getEventType() == EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW) {
                WorkflowExecution nextWorkflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowExecution.getWorkflowId()).setRunId(event.getWorkflowExecutionContinuedAsNewEventAttributes().getNewExecutionRunId()).build();
                return WorkflowClientLongPollAsyncHelper.getInstanceCloseEventAsync(service, workflowClientHelper, nextWorkflowExecution, r.getNextPageToken(), timeout, unit);
            }
            return CompletableFuture.completedFuture(event);
        });
    }

    private static CompletableFuture<GetWorkflowExecutionHistoryResponse> getWorkflowExecutionHistoryAsync(WorkflowServiceStubs service, GetWorkflowExecutionHistoryRequest r, long timeout, TimeUnit unit) {
        long start = System.currentTimeMillis();
        RpcRetryOptions retryOptions = DefaultStubLongPollRpcRetryOptions.getBuilder().setExpiration(Duration.ofMillis(unit.toMillis(timeout))).build();
        return GrpcRetryer.retryWithResultAsync((RpcRetryOptions)retryOptions, () -> {
            CompletableFuture result = new CompletableFuture();
            long elapsedInRetry = System.currentTimeMillis() - start;
            Deadline expirationInRetry = Deadline.after((long)(unit.toMillis(timeout) - elapsedInRetry), (TimeUnit)TimeUnit.MILLISECONDS);
            ListenableFuture resultFuture = ((WorkflowServiceGrpc.WorkflowServiceFutureStub)service.futureStub().withDeadline(expirationInRetry)).getWorkflowExecutionHistory(r);
            resultFuture.addListener(() -> {
                try {
                    result.complete((GetWorkflowExecutionHistoryResponse)resultFuture.get());
                }
                catch (ExecutionException e) {
                    result.completeExceptionally(e.getCause());
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            }, (Executor)ForkJoinPool.commonPool());
            return result;
        });
    }
}

