/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.grpc.Deadline;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.RootWorkflowClientHelper;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.rpcretry.DefaultStubLongPollRpcRetryOptions;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class WorkflowClientLongPollHelper {
    WorkflowClientLongPollHelper() {
    }

    static Optional<Payloads> getWorkflowExecutionResult(WorkflowServiceStubs service, RootWorkflowClientHelper workflowClientHelper, WorkflowExecution workflowExecution, Optional<String> workflowType, Scope metricsScope, DataConverter converter, long timeout, TimeUnit unit) throws TimeoutException {
        HistoryEvent closeEvent = WorkflowClientLongPollHelper.getInstanceCloseEvent(service, workflowClientHelper, workflowExecution, metricsScope, timeout, unit);
        return WorkflowExecutionUtils.getResultFromCloseEvent(workflowExecution, workflowType, closeEvent, converter);
    }

    static WorkflowExecutionStatus waitForWorkflowInstanceCompletion(WorkflowServiceStubs service, RootWorkflowClientHelper workflowClientHelper, WorkflowExecution workflowExecution, Scope metricsScope, long timeout, TimeUnit unit) throws TimeoutException {
        HistoryEvent closeEvent = WorkflowClientLongPollHelper.getInstanceCloseEvent(service, workflowClientHelper, workflowExecution, metricsScope, timeout, unit);
        return WorkflowExecutionUtils.getCloseStatus(closeEvent);
    }

    private static HistoryEvent getInstanceCloseEvent(WorkflowServiceStubs service, RootWorkflowClientHelper workflowClientHelper, WorkflowExecution workflowExecution, Scope metricsScope, long timeout, TimeUnit unit) throws TimeoutException {
        HistoryEvent event;
        ByteString pageToken = ByteString.EMPTY;
        long start = System.currentTimeMillis();
        while (true) {
            GetWorkflowExecutionHistoryResponse response;
            GetWorkflowExecutionHistoryRequest request = workflowClientHelper.newHistoryLongPollRequest(workflowExecution, pageToken);
            long elapsed = System.currentTimeMillis() - start;
            long millisRemaining = unit.toMillis(timeout != 0L ? timeout : Integer.MAX_VALUE) - elapsed;
            if (millisRemaining > 0L) {
                RpcRetryOptions retryOptions = DefaultStubLongPollRpcRetryOptions.getBuilder().setExpiration(Duration.ofMillis(millisRemaining)).build();
                response = (GetWorkflowExecutionHistoryResponse)GrpcRetryer.retryWithResult((RpcRetryOptions)retryOptions, () -> {
                    long elapsedInRetry = System.currentTimeMillis() - start;
                    Deadline expirationInRetry = Deadline.after((long)(unit.toMillis(timeout) - elapsedInRetry), (TimeUnit)TimeUnit.MILLISECONDS);
                    return ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(expirationInRetry)).getWorkflowExecutionHistory(request);
                });
                if (response == null || !response.hasHistory()) {
                    continue;
                }
            } else {
                throw new TimeoutException("WorkflowId=" + workflowExecution.getWorkflowId() + ", runId=" + workflowExecution.getRunId() + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit));
            }
            pageToken = response.getNextPageToken();
            History history = response.getHistory();
            if (history.getEventsCount() <= 0) continue;
            event = history.getEvents(0);
            if (!WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)event)) {
                throw new RuntimeException("Last history event is not completion event: " + event);
            }
            if (event.getEventType() != EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW) break;
            pageToken = ByteString.EMPTY;
            workflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowExecution.getWorkflowId()).setRunId(event.getWorkflowExecutionContinuedAsNewEventAttributes().getNewExecutionRunId()).build();
        }
        return event;
    }
}

